/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;

public class ChainBuilder {
    private List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();

    public ChainBuilder add(ByteBuffer payload) {
        this.buffers.add(payload);
        return this;
    }

    public Chain build() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (ByteBuffer buffer : this.buffers) {
            elements.add(buffer::asReadOnlyBuffer);
        }
        return ChainBuilder.chainFromList(elements);
    }

    public int length() {
        return this.buffers.size();
    }

    public static Chain chainFromList(final List<Element> elements) {
        return new Chain(){

            @Override
            public boolean isEmpty() {
                return elements.isEmpty();
            }

            @Override
            public int length() {
                return elements.size();
            }

            @Override
            public Iterator<Element> iterator() {
                return elements.iterator();
            }
        };
    }
}

