/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.delete;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.job.service.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.impl.QueryOperator;

public class BatchDeleteProcessConfig {
    protected final Batch batch;
    protected final BatchPart batchPart;
    protected final String error;
    protected final boolean sequentialExecution;
    protected int batchSize;
    protected HistoricProcessInstanceQuery query;

    protected BatchDeleteProcessConfig(Batch batch, BatchPart batchPart, String error, boolean sequentialExecution) {
        this.batch = batch;
        this.batchPart = batchPart;
        this.error = error;
        this.sequentialExecution = sequentialExecution;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public BatchPart getBatchPart() {
        return this.batchPart;
    }

    public String getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean isSequentialExecution() {
        return this.sequentialExecution;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public HistoricProcessInstanceQuery getQuery() {
        return this.query;
    }

    public static BatchDeleteProcessConfig create(String batchPartId, ProcessEngineConfigurationImpl engineConfiguration) {
        HistoricProcessInstanceQuery query;
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        BatchPart batchPart = batchService.getBatchPart(batchPartId);
        if (batchPart == null) {
            throw new FlowableIllegalArgumentException("There is no batch part with the id " + batchPartId);
        }
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        JsonNode batchConfiguration = BatchDeleteProcessConfig.getBatchConfiguration(batch, engineConfiguration);
        boolean sequentialExecution = batchConfiguration.path("sequential").booleanValue();
        JsonNode queryNode = batchConfiguration.path("query");
        if (queryNode.isMissingNode()) {
            return new BatchDeleteProcessConfig(batch, batchPart, BatchDeleteProcessConfig.prepareFailedResultAsJsonString("Batch configuration has no query definition", engineConfiguration), sequentialExecution);
        }
        JsonNode batchSizeNode = batchConfiguration.path("batchSize");
        if (batchSizeNode.isMissingNode()) {
            return new BatchDeleteProcessConfig(batch, batchPart, BatchDeleteProcessConfig.prepareFailedResultAsJsonString("Batch configuration has no batch size", engineConfiguration), sequentialExecution);
        }
        try {
            query = BatchDeleteProcessConfig.createQuery(queryNode, engineConfiguration);
        }
        catch (FlowableException exception) {
            return new BatchDeleteProcessConfig(batch, batchPart, BatchDeleteProcessConfig.prepareFailedResultAsJsonString("Failed to create query", exception, engineConfiguration), sequentialExecution);
        }
        BatchDeleteProcessConfig config = new BatchDeleteProcessConfig(batch, batchPart, null, sequentialExecution);
        config.batchSize = batchSizeNode.intValue();
        config.query = query;
        return config;
    }

    protected static HistoricProcessInstanceQuery createQuery(JsonNode queryNode, ProcessEngineConfigurationImpl engineConfiguration) {
        HistoricProcessInstanceQuery query = engineConfiguration.getHistoryService().createHistoricProcessInstanceQuery();
        BatchDeleteProcessConfig.populateQuery(queryNode, query, engineConfiguration);
        if (queryNode.hasNonNull("finishedBefore") || queryNode.hasNonNull("finishedAfter") || queryNode.path("finished").asBoolean(false)) {
            query.orderByProcessInstanceEndTime().asc();
        }
        return query;
    }

    protected static void populateQuery(JsonNode queryNode, HistoricProcessInstanceQuery query, ProcessEngineConfigurationImpl engineConfiguration) {
        Iterator fieldIterator = queryNode.fields();
        block96: while (fieldIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIterator.next();
            String property = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            switch (property) {
                case "processInstanceId": {
                    query.processInstanceId(value.textValue());
                    continue block96;
                }
                case "processDefinitionId": {
                    query.processDefinitionId(value.textValue());
                    continue block96;
                }
                case "businessKey": {
                    query.processInstanceBusinessKey(value.textValue());
                    continue block96;
                }
                case "businessKeyLike": {
                    query.processInstanceBusinessKeyLike(value.textValue());
                    continue block96;
                }
                case "businessStatus": {
                    query.processInstanceBusinessStatus(value.textValue());
                    continue block96;
                }
                case "businessStatusLike": {
                    query.processInstanceBusinessStatusLike(value.textValue());
                    continue block96;
                }
                case "deploymentId": {
                    query.deploymentId(value.textValue());
                    continue block96;
                }
                case "deploymentIds": {
                    query.deploymentIdIn(BatchDeleteProcessConfig.asStringList(value));
                    continue block96;
                }
                case "finished": {
                    if (!value.booleanValue()) continue block96;
                    query.finished();
                    continue block96;
                }
                case "unfinished": {
                    if (!value.booleanValue()) continue block96;
                    query.unfinished();
                    continue block96;
                }
                case "deleted": {
                    if (!value.booleanValue()) continue block96;
                    query.deleted();
                    continue block96;
                }
                case "notDeleted": {
                    if (!value.booleanValue()) continue block96;
                    query.notDeleted();
                    continue block96;
                }
                case "startedBy": {
                    query.startedBy(value.textValue());
                    continue block96;
                }
                case "superProcessInstanceId": {
                    query.superProcessInstanceId(value.textValue());
                    continue block96;
                }
                case "excludeSubprocesses": {
                    if (!value.booleanValue()) continue block96;
                    query.excludeSubprocesses(true);
                    continue block96;
                }
                case "processDefinitionKeyIn": {
                    query.processDefinitionKeyIn(BatchDeleteProcessConfig.asStringList(value));
                    continue block96;
                }
                case "processKeyNotIn": {
                    query.processDefinitionKeyNotIn(BatchDeleteProcessConfig.asStringList(value));
                    continue block96;
                }
                case "startedBefore": {
                    query.startedBefore(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block96;
                }
                case "startedAfter": {
                    query.startedAfter(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block96;
                }
                case "finishedBefore": {
                    query.finishedBefore(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block96;
                }
                case "finishedAfter": {
                    query.finishedAfter(AsyncHistoryDateUtil.parseDate((String)value.textValue()));
                    continue block96;
                }
                case "processDefinitionKey": {
                    query.processDefinitionKey(value.textValue());
                    continue block96;
                }
                case "processDefinitionCategory": {
                    query.processDefinitionCategory(value.textValue());
                    continue block96;
                }
                case "processDefinitionName": {
                    query.processDefinitionName(value.textValue());
                    continue block96;
                }
                case "processDefinitionVersion": {
                    query.processDefinitionVersion(value.intValue());
                    continue block96;
                }
                case "processInstanceIds": {
                    query.processInstanceIds(BatchDeleteProcessConfig.asStringSet(value));
                    continue block96;
                }
                case "activeActivityId": {
                    query.activeActivityId(value.textValue());
                    continue block96;
                }
                case "activeActivityIds": {
                    query.activeActivityIds(BatchDeleteProcessConfig.asStringSet(value));
                    continue block96;
                }
                case "involvedUser": {
                    query.involvedUser(value.textValue());
                    continue block96;
                }
                case "involvedUserIdentityLink": {
                    query.involvedUser(value.path("userId").textValue(), value.path("type").textValue());
                    continue block96;
                }
                case "involvedGroups": {
                    query.involvedGroups(BatchDeleteProcessConfig.asStringSet(value));
                    continue block96;
                }
                case "involvedGroupIdentityLink": {
                    query.involvedUser(value.path("groupId").textValue(), value.path("type").textValue());
                    continue block96;
                }
                case "withJobException": {
                    if (!value.booleanValue()) continue block96;
                    query.withJobException();
                    continue block96;
                }
                case "tenantId": {
                    query.processInstanceTenantId(value.textValue());
                    continue block96;
                }
                case "tenantIdLike": {
                    query.processInstanceTenantIdLike(value.textValue());
                    continue block96;
                }
                case "withoutTenantId": {
                    if (!value.booleanValue()) continue block96;
                    query.processInstanceWithoutTenantId();
                    continue block96;
                }
                case "name": {
                    query.processInstanceName(value.textValue());
                    continue block96;
                }
                case "nameLike": {
                    query.processInstanceNameLike(value.textValue());
                    continue block96;
                }
                case "nameLikeIgnoreCase": {
                    query.processInstanceNameLikeIgnoreCase(value.textValue());
                    continue block96;
                }
                case "callbackId": {
                    query.processInstanceCallbackId(value.textValue());
                    continue block96;
                }
                case "callbackType": {
                    query.processInstanceCallbackType(value.textValue());
                    continue block96;
                }
                case "withoutCallbackId": {
                    if (!value.booleanValue()) continue block96;
                    query.withoutProcessInstanceCallbackId();
                    continue block96;
                }
                case "referenceId": {
                    query.processInstanceReferenceId(value.textValue());
                    continue block96;
                }
                case "referenceType": {
                    query.processInstanceReferenceType(value.textValue());
                    continue block96;
                }
                case "queryVariableValues": {
                    BatchDeleteProcessConfig.populateQueryVariableValues(value, query, engineConfiguration);
                    continue block96;
                }
                case "orQueryObjects": {
                    BatchDeleteProcessConfig.populateOrQueryObjects(value, query, engineConfiguration);
                    continue block96;
                }
            }
            throw new FlowableIllegalArgumentException("Query property " + property + " is not supported");
        }
    }

    protected static void populateOrQueryObjects(JsonNode orQueryObjectsNode, HistoricProcessInstanceQuery query, ProcessEngineConfigurationImpl engineConfiguration) {
        if (orQueryObjectsNode.isArray()) {
            for (JsonNode orQueryObjectNode : orQueryObjectsNode) {
                HistoricProcessInstanceQuery orQuery = query.or();
                BatchDeleteProcessConfig.populateQuery(orQueryObjectNode, orQuery, engineConfiguration);
                query.endOr();
            }
        }
    }

    protected static void populateQueryVariableValues(JsonNode variableValuesNode, HistoricProcessInstanceQuery query, ProcessEngineConfigurationImpl engineConfiguration) {
        if (variableValuesNode.isArray()) {
            block13: for (JsonNode variableValue : variableValuesNode) {
                String operatorString = variableValue.path("operator").asText(null);
                if (operatorString == null) {
                    throw new FlowableIllegalArgumentException("The variable value does not contain an operator value");
                }
                QueryOperator operator = QueryOperator.valueOf((String)operatorString);
                String variableName = variableValue.path("name").textValue();
                switch (operator) {
                    case EQUALS: {
                        if (variableName != null) {
                            query.variableValueEquals(variableName, BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                            continue block13;
                        }
                        query.variableValueEquals(BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case NOT_EQUALS: {
                        query.variableValueNotEquals(variableName, BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case GREATER_THAN: {
                        query.variableValueGreaterThan(variableName, BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        query.variableValueGreaterThanOrEqual(variableName, BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LESS_THAN: {
                        query.variableValueLessThan(variableName, BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LESS_THAN_OR_EQUAL: {
                        query.variableValueLessThanOrEqual(variableName, BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LIKE: {
                        query.variableValueLike(variableName, (String)BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case LIKE_IGNORE_CASE: {
                        query.variableValueLikeIgnoreCase(variableName, (String)BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case EQUALS_IGNORE_CASE: {
                        query.variableValueEqualsIgnoreCase(variableName, (String)BatchDeleteProcessConfig.extractVariableValue(variableValue, engineConfiguration));
                        continue block13;
                    }
                    case EXISTS: {
                        query.variableExists(variableName);
                        continue block13;
                    }
                    case NOT_EXISTS: {
                        query.variableNotExists(variableName);
                        continue block13;
                    }
                }
                throw new FlowableIllegalArgumentException("Operator " + operator + " is not supported for the variable value");
            }
        }
    }

    protected static Object extractVariableValue(JsonNode variableValueNode, ProcessEngineConfigurationImpl engineConfiguration) {
        String type = variableValueNode.path("type").asText(null);
        if (type == null) {
            throw new FlowableIllegalArgumentException("The variable value does not have a type");
        }
        VariableType variableType = engineConfiguration.getVariableTypes().getVariableType(type);
        return variableType.getValue((ValueFields)new VariableValueJsonNodeValueFields(variableValueNode));
    }

    protected static List<String> asStringList(JsonNode node) {
        if (node != null && node.isArray() && node.size() > 0) {
            ArrayList<String> values = new ArrayList<String>(node.size());
            for (JsonNode element : node) {
                values.add(element.textValue());
            }
            return values;
        }
        return null;
    }

    protected static Set<String> asStringSet(JsonNode node) {
        if (node != null && node.isArray() && node.size() > 0) {
            ArrayList<String> values = new ArrayList<String>(node.size());
            for (JsonNode element : node) {
                values.add(element.textValue());
            }
            return new HashSet<String>(values);
        }
        return null;
    }

    protected static JsonNode getBatchConfiguration(Batch batch, ProcessEngineConfigurationImpl engineConfiguration) {
        try {
            return engineConfiguration.getObjectMapper().readTree(batch.getBatchDocumentJson("cfg.processEngine"));
        }
        catch (JsonProcessingException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
            return null;
        }
    }

    protected static String prepareFailedResultAsJsonString(String errorMessage, ProcessEngineConfigurationImpl engineConfiguration) {
        return BatchDeleteProcessConfig.prepareFailedResultAsJsonString(errorMessage, null, engineConfiguration);
    }

    protected static String prepareFailedResultAsJsonString(String errorMessage, FlowableException exception, ProcessEngineConfigurationImpl engineConfiguration) {
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        resultNode.put("errorMessage", errorMessage);
        if (exception != null) {
            resultNode.put("errorStacktrace", ExceptionUtils.getStackTrace((Throwable)exception));
        }
        return resultNode.toString();
    }

    protected static class VariableValueJsonNodeValueFields
    implements ValueFields {
        protected final JsonNode node;

        public VariableValueJsonNodeValueFields(JsonNode node) {
            this.node = node;
        }

        public String getName() {
            return this.node.path("name").textValue();
        }

        public String getProcessInstanceId() {
            throw new UnsupportedOperationException("Not supported to get process instance id");
        }

        public String getExecutionId() {
            throw new UnsupportedOperationException("Not supported to get execution id");
        }

        public String getScopeId() {
            throw new UnsupportedOperationException("Not supported to get scope id");
        }

        public String getSubScopeId() {
            throw new UnsupportedOperationException("Not supported to get sub scope id");
        }

        public String getScopeType() {
            throw new UnsupportedOperationException("Not supported to scope type");
        }

        public String getTaskId() {
            throw new UnsupportedOperationException("Not supported to get task id");
        }

        public String getTextValue() {
            return this.node.path("textValue").textValue();
        }

        public void setTextValue(String textValue) {
            throw new UnsupportedOperationException("Not supported to set text value");
        }

        public String getTextValue2() {
            return this.node.path("textValues").textValue();
        }

        public void setTextValue2(String textValue2) {
            throw new UnsupportedOperationException("Not supported to set text value2");
        }

        public Long getLongValue() {
            JsonNode longNode = this.node.path("longValue");
            if (longNode.isNumber()) {
                return longNode.longValue();
            }
            return null;
        }

        public void setLongValue(Long longValue) {
            throw new UnsupportedOperationException("Not supported to set long value");
        }

        public Double getDoubleValue() {
            JsonNode doubleNode = this.node.path("doubleValue");
            if (doubleNode.isNumber()) {
                return doubleNode.doubleValue();
            }
            return null;
        }

        public void setDoubleValue(Double doubleValue) {
            throw new UnsupportedOperationException("Not supported to set double value");
        }

        public byte[] getBytes() {
            throw new UnsupportedOperationException("Not supported to get bytes");
        }

        public void setBytes(byte[] bytes) {
            throw new UnsupportedOperationException("Not supported to set bytes");
        }

        public Object getCachedValue() {
            throw new UnsupportedOperationException("Not supported to set get cached value");
        }

        public void setCachedValue(Object cachedValue) {
            throw new UnsupportedOperationException("Not supported to set cached value");
        }
    }
}

