/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.support;

import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.flowable.common.engine.api.Engine;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.ProcessMigrationService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.impl.ProcessEngineImpl;

public class DomainProcessEngine
implements ProcessEngine {
    private final Map<String, ProcessEngine> engines;

    public DomainProcessEngine(Map<String, ProcessEngine> engines) {
        this.engines = Collections.synchronizedMap(engines);
    }

    public Map<String, ProcessEngine> getEngines() {
        return this.engines;
    }

    public String getName() {
        return this.engines.get(AuthContextUtils.getDomain()).getName();
    }

    public void close() {
        this.engines.values().forEach(Engine::close);
    }

    public RepositoryService getRepositoryService() {
        return this.engines.get(AuthContextUtils.getDomain()).getRepositoryService();
    }

    public RuntimeService getRuntimeService() {
        return this.engines.get(AuthContextUtils.getDomain()).getRuntimeService();
    }

    public FormService getFormService() {
        return this.engines.get(AuthContextUtils.getDomain()).getFormService();
    }

    public TaskService getTaskService() {
        return this.engines.get(AuthContextUtils.getDomain()).getTaskService();
    }

    public HistoryService getHistoryService() {
        return this.engines.get(AuthContextUtils.getDomain()).getHistoryService();
    }

    public IdentityService getIdentityService() {
        return this.engines.get(AuthContextUtils.getDomain()).getIdentityService();
    }

    public ManagementService getManagementService() {
        return this.engines.get(AuthContextUtils.getDomain()).getManagementService();
    }

    public ProcessEngineConfiguration getProcessEngineConfiguration() {
        return this.engines.get(AuthContextUtils.getDomain()).getProcessEngineConfiguration();
    }

    public DynamicBpmnService getDynamicBpmnService() {
        return this.engines.get(AuthContextUtils.getDomain()).getDynamicBpmnService();
    }

    public ProcessMigrationService getProcessMigrationService() {
        return this.engines.get(AuthContextUtils.getDomain()).getProcessMigrationService();
    }

    public void startExecutors() {
        this.engines.get(AuthContextUtils.getDomain()).startExecutors();
    }

    public DataSource getDataSource() {
        ProcessEngineImpl engine = (ProcessEngineImpl)this.engines.get(AuthContextUtils.getDomain());
        return engine.getProcessEngineConfiguration().getDataSource();
    }
}

