/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security.jws;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jca.JCAAware;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.Base64URL;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSEntraAccessTokenJWSVerifier
implements JWSVerifier {
    protected static final Logger LOG = LoggerFactory.getLogger(MSEntraAccessTokenJWSVerifier.class);
    protected final String tenantId;
    protected final String appId;
    protected final Duration cacheExpireAfterWrite;
    protected final HttpClient httpClient;
    protected final JsonMapper jsonMapper;
    protected final LoadingCache<String, JWSVerifier> verifiersCache;

    public MSEntraAccessTokenJWSVerifier(String tenantId, String appId, Duration cacheExpireAfterWrite) {
        this.tenantId = tenantId;
        this.appId = appId;
        this.cacheExpireAfterWrite = cacheExpireAfterWrite;
        this.httpClient = HttpClient.newHttpClient();
        this.jsonMapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
        this.verifiersCache = Caffeine.newBuilder().expireAfterWrite(cacheExpireAfterWrite).build((CacheLoader)new CacheLoader<String, JWSVerifier>(){

            public JWSVerifier load(String key) {
                return this.loadAll(Set.of(key)).get(key);
            }

            public Map<String, JWSVerifier> loadAll(Iterable<? extends String> keys) {
                String openIdDocUrl = MSEntraAccessTokenJWSVerifier.this.getOpenIDMetadataDocumentUrl();
                String openIdDoc = MSEntraAccessTokenJWSVerifier.this.fetchDocument(openIdDocUrl);
                String jwksUri = MSEntraAccessTokenJWSVerifier.this.extractJwksUri(openIdDoc);
                String jwks = MSEntraAccessTokenJWSVerifier.this.fetchDocument(jwksUri);
                return MSEntraAccessTokenJWSVerifier.this.parseJsonWebKeySet(jwks);
            }
        });
    }

    protected String getOpenIDMetadataDocumentUrl() {
        return String.format("https://login.microsoftonline.com/%s/.well-known/openid-configuration%s", Optional.ofNullable(this.tenantId).orElse("common"), Optional.ofNullable(this.appId).map(i -> String.format("?appid=%s", i)).orElse(""));
    }

    protected String extractJwksUri(String openIdMetadataDocument) {
        try {
            return this.jsonMapper.readTree(openIdMetadataDocument).get("jwks_uri").asText();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Extracting value of 'jwks_url' key from OpenID Metadata JSON document for Microsoft Entra failed:", e);
        }
    }

    protected String fetchDocument(String url) {
        try {
            HttpResponse<String> response = this.httpClient.send(HttpRequest.newBuilder().uri(URI.create(url)).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 400) {
                throw new IllegalStateException(String.format("Received HTTP status code %d", response.statusCode()));
            }
            return response.body();
        }
        catch (IOException | IllegalStateException | InterruptedException e) {
            throw new IllegalStateException(String.format("Fetching JSON document for Microsoft Entra from '%s' failed:", url), e);
        }
    }

    protected Map<String, JWSVerifier> parseJsonWebKeySet(String jsonWebKeySet) {
        List fetchedKeys;
        try {
            fetchedKeys = JWKSet.parse((String)jsonWebKeySet).getKeys();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Parsing JSON Web Key Set for MS Entra failed:", e);
        }
        HashMap<String, JWSVerifier> verifiers = new HashMap<String, JWSVerifier>();
        for (JWK key : fetchedKeys) {
            if (!(key instanceof AsymmetricJWK)) {
                LOG.warn("Skipped non-asymmetric JSON Web Key with key id '{}' from retrieved JSON Web Key Set for Microsoft Entra", (Object)key.getKeyID());
                continue;
            }
            try {
                PublicKey pubKey = ((AsymmetricJWK)key).toPublicKey();
                if (pubKey instanceof RSAPublicKey) {
                    verifiers.put(key.getKeyID(), (JWSVerifier)new RSASSAVerifier((RSAPublicKey)pubKey));
                    continue;
                }
                if (!(pubKey instanceof ECPublicKey)) continue;
                verifiers.put(key.getKeyID(), (JWSVerifier)new ECDSAVerifier((ECPublicKey)pubKey));
            }
            catch (JOSEException e) {
                throw new IllegalArgumentException("Extracting public key from asymmetric JSON Web Key from retrieved JSON Web Key Set for Microsoft Entra failed:", e);
            }
        }
        return verifiers;
    }

    protected Map<String, JWSVerifier> getAllFromCache() {
        this.verifiersCache.getAll(Set.of(""));
        return this.verifiersCache.asMap();
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return this.getAllFromCache().values().stream().flatMap(jwsVerifier -> jwsVerifier.supportedJWSAlgorithms().stream()).collect(Collectors.toSet());
    }

    public JCAContext getJCAContext() {
        return this.getAllFromCache().values().stream().map(JCAAware::getJCAContext).findFirst().orElseThrow(() -> new IllegalStateException("JSON Web Key Set cache for Microsoft Entra is empty"));
    }

    public boolean verify(JWSHeader header, byte[] signingInput, Base64URL signature) throws JOSEException {
        String keyId = header.getKeyID();
        JWSVerifier delegate = Optional.ofNullable((JWSVerifier)this.verifiersCache.get((Object)keyId)).orElseThrow(() -> new JOSEException(String.format("Microsoft Entra JSON Web Key Set cache could not retrieve a public key for given key id '%s'", keyId)));
        return delegate.verify(header, signingInput, signature);
    }
}

