/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.idm.api.Group;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntity;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class SaveGroupCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected IdmEngineConfiguration idmEngineConfiguration;
    protected Group group;

    public SaveGroupCmd(Group group, IdmEngineConfiguration idmEngineConfiguration) {
        this.group = group;
        this.idmEngineConfiguration = idmEngineConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        if (this.group == null) {
            throw new FlowableIllegalArgumentException("group is null");
        }
        if (this.idmEngineConfiguration.getGroupEntityManager().isNewGroup(this.group)) {
            if (this.group instanceof GroupEntity) {
                this.idmEngineConfiguration.getGroupEntityManager().insert((GroupEntity)this.group);
            } else {
                CommandContextUtil.getDbSqlSession(commandContext).insert((Entity)this.group, this.idmEngineConfiguration.getIdGenerator());
            }
        } else if (this.group instanceof GroupEntity) {
            this.idmEngineConfiguration.getGroupEntityManager().update((GroupEntity)this.group);
        } else {
            CommandContextUtil.getDbSqlSession(commandContext).update((Entity)this.group);
        }
        return null;
    }
}

