/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.service.JAXRSService;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService
implements JAXRSService {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    protected static final String OPTIONS_ALLOW = "GET,POST,OPTIONS,HEAD";
    @Context
    protected UriInfo uriInfo;
    @Context
    protected MessageContext messageContext;
    @Context
    protected SearchContext searchContext;

    protected String findActualKey(AnyDAO<?> dao, String pretendingKey) {
        String actualKey = pretendingKey;
        if (this.uriInfo.getPathParameters(true).containsKey((Object)"key")) {
            String keyInPath = (String)((List)this.uriInfo.getPathParameters(true).get((Object)"key")).get(0);
            if (actualKey == null) {
                actualKey = keyInPath;
            } else if (!actualKey.equals(keyInPath)) {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
                sce.getElements().add("Key specified in request does not match key in the path");
                throw sce;
            }
        }
        if (actualKey == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Key is null");
            throw sce;
        }
        if (!SyncopeConstants.UUID_PATTERN.matcher(actualKey).matches()) {
            actualKey = dao instanceof UserDAO ? ((UserDAO)dao).findKey(actualKey) : (dao instanceof GroupDAO ? ((GroupDAO)dao).findKey(actualKey) : null);
        }
        return actualKey;
    }

    protected boolean isNullPriorityAsync() {
        return BooleanUtils.toBoolean((String)this.messageContext.getHttpServletRequest().getHeader("X-Syncope-Null-Priority-Async"));
    }

    protected Preference getPreference() {
        return Preference.fromString((String)this.messageContext.getHttpServletRequest().getHeader("Prefer"));
    }

    protected Response.ResponseBuilder applyPreference(ProvisioningResult<?> provisioningResult, Response.ResponseBuilder builder) {
        switch (this.getPreference()) {
            case RETURN_NO_CONTENT: {
                break;
            }
            default: {
                builder.entity(provisioningResult);
            }
        }
        if (this.getPreference() == Preference.RETURN_CONTENT || this.getPreference() == Preference.RETURN_NO_CONTENT) {
            builder.header("Preference-Applied", (Object)this.getPreference().toString());
        }
        return builder;
    }

    protected Response createResponse(ProvisioningResult<?> provisioningResult) {
        String entityId = provisioningResult.getEntity().getKey();
        Response.ResponseBuilder builder = Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(entityId).build(new Object[0])).header("X-Syncope-Key", (Object)entityId);
        return this.applyPreference(provisioningResult, builder).build();
    }

    protected Response modificationResponse(Object entity) {
        Response.ResponseBuilder builder;
        switch (this.getPreference()) {
            case RETURN_NO_CONTENT: {
                builder = Response.noContent();
                break;
            }
            default: {
                builder = Response.ok((Object)entity);
            }
        }
        if (this.getPreference() == Preference.RETURN_CONTENT || this.getPreference() == Preference.RETURN_NO_CONTENT) {
            builder.header("Preference-Applied", (Object)this.getPreference().toString());
        }
        return builder.build();
    }

    protected void checkETag(String etag) {
        Response.ResponseBuilder builder = this.messageContext.getRequest().evaluatePreconditions(new EntityTag(etag));
        if (builder != null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.ConcurrentModification);
            sce.getElements().add("Mismatching ETag value");
            throw sce;
        }
    }

    protected List<OrderByClause> getOrderByClauses(String orderBy) {
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            return List.of();
        }
        ArrayList<OrderByClause> result = new ArrayList<OrderByClause>();
        for (String clause : orderBy.split(",")) {
            String[] elems = clause.trim().split(" ");
            if (elems.length <= 0 || !StringUtils.isNotBlank((CharSequence)elems[0])) continue;
            OrderByClause obc = new OrderByClause();
            obc.setField(elems[0].trim());
            if (elems.length > 1 && StringUtils.isNotBlank((CharSequence)elems[1])) {
                obc.setDirection(elems[1].trim().equalsIgnoreCase(OrderByClause.Direction.ASC.name()) ? OrderByClause.Direction.ASC : OrderByClause.Direction.DESC);
            }
            result.add(obc);
        }
        return result;
    }

    protected <T extends BaseBean> PagedResult<T> buildPagedResult(List<T> list, int page, int size, int totalCount) {
        PagedResult result = new PagedResult();
        result.getResult().addAll(list);
        result.setPage(page);
        result.setSize(result.getResult().size());
        result.setTotalCount(totalCount);
        UriBuilder builder = this.uriInfo.getAbsolutePathBuilder();
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        queryParams.forEach((key, value) -> builder.queryParam(key, value.toArray()));
        if (result.getPage() > 1) {
            result.setPrev(builder.replaceQueryParam("page", new Object[]{result.getPage() - 1}).replaceQueryParam("size", new Object[]{size}).build(new Object[0]));
        }
        if ((result.getPage() - 1) * size + result.getSize() < totalCount) {
            result.setNext(builder.replaceQueryParam("page", new Object[]{result.getPage() + 1}).replaceQueryParam("size", new Object[]{size}).build(new Object[0]));
        }
        return result;
    }
}

