/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class AcceptableUsagePolicyWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public AcceptableUsagePolicyWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createVerifyActionState(flow);
            this.createAcceptableUsagePolicyView(flow);
            this.createSubmitActionState(flow);
            this.createTransitionStateToAcceptableUsagePolicy(flow);
        }
    }

    protected void createTransitionStateToAcceptableUsagePolicy(Flow flow) {
        ActionState submit = this.getRealSubmissionState(flow);
        this.createTransitionForState((TransitionableState)submit, "success", "acceptableUsagePolicyCheck", true);
    }

    protected ActionState getRealSubmissionState(Flow flow) {
        return (ActionState)this.getState(flow, "realSubmit", ActionState.class);
    }

    protected void createSubmitActionState(Flow flow) {
        ActionState aupAcceptedAction = this.createActionState(flow, "aupAcceptedAction", new String[]{"acceptableUsagePolicySubmitAction"});
        String target = this.getRealSubmissionState(flow).getTransition("success").getTargetStateId();
        TransitionSet transitionSet = aupAcceptedAction.getTransitionSet();
        transitionSet.add(this.createTransition("acceptedUsagePolicy", target));
        transitionSet.add(this.createTransition("error", "initializeLoginForm"));
    }

    protected void createAcceptableUsagePolicyView(Flow flow) {
        ViewState viewState = this.createViewState(flow, "acceptableUsagePolicyView", "aup/casAcceptableUsagePolicyView");
        this.createTransitionForState((TransitionableState)viewState, "submit", "aupAcceptedAction");
        viewState.getRenderActionList().add((Action)this.createEvaluateAction("acceptableUsagePolicyRenderAction"));
    }

    protected void createVerifyActionState(Flow flow) {
        ActionState actionState = this.createActionState(flow, "acceptableUsagePolicyCheck", new String[]{"acceptableUsagePolicyVerifyAction"});
        TransitionSet transitionSet = actionState.getTransitionSet();
        String target = this.getRealSubmissionState(flow).getTransition("success").getTargetStateId();
        transitionSet.add(this.createTransition("acceptedUsagePolicy", target));
        transitionSet.add(this.createTransition("skip", target));
        transitionSet.add(this.createTransition("mustAcceptUsagePolicy", "acceptableUsagePolicyView"));
        ActionState ticketCreateState = (ActionState)this.getState(flow, "createTicketGrantingTicket", ActionState.class);
        this.createEvaluateActionForExistingActionState(flow, ticketCreateState.getId(), "acceptableUsagePolicyVerifyAction");
        this.createTransitionForState((TransitionableState)ticketCreateState, "mustAcceptUsagePolicy", "acceptableUsagePolicyView");
        ActionState genServiceTicketState = (ActionState)this.getState(flow, "generateServiceTicket", ActionState.class);
        this.createEvaluateActionForExistingActionState(flow, genServiceTicketState.getId(), "acceptableUsagePolicyVerifyServiceAction");
        this.createTransitionForState((TransitionableState)genServiceTicketState, "mustAcceptUsagePolicy", "acceptableUsagePolicyView");
    }
}

