/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseMeta;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseResource;
import org.identityconnectors.common.logging.Log;

public abstract class AbstractSCIMBaseResource<MT extends SCIMBaseMeta>
implements SCIMBaseResource<MT> {
    private static final long serialVersionUID = 3673404125396687366L;
    protected static final Log LOG = Log.getLog(AbstractSCIMBaseResource.class);
    @JsonProperty
    protected MT meta;
    @JsonProperty
    protected String id;
    @JsonProperty
    protected final Set<String> schemas = new TreeSet<String>();
    @JsonIgnore
    protected String baseSchema;

    public AbstractSCIMBaseResource() {
    }

    public AbstractSCIMBaseResource(MT meta) {
        this.meta = meta;
    }

    @Override
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    public void setSchemas(Set<String> schemas) {
        this.schemas.clear();
        Optional.ofNullable(schemas).ifPresent(this.schemas::addAll);
    }

    @Override
    public MT getMeta() {
        return this.meta;
    }

    @Override
    public void setMeta(MT meta) {
        this.meta = meta;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

