/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.EventHandlerException;
import com.tc.async.api.MultiThreadedEventContext;
import com.tc.async.api.Source;
import com.tc.async.impl.AbstractStageQueueImpl;
import com.tc.async.impl.Event;
import com.tc.async.impl.EventCreator;
import com.tc.logging.TCLoggerProvider;
import com.tc.util.Assert;
import com.tc.util.concurrent.QueueFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class MultiStageQueueImpl<EC extends MultiThreadedEventContext>
extends AbstractStageQueueImpl<EC> {
    static final String FINDSTRATEGY_PROPNAME = "tc.stagequeueimpl.findstrategy";
    static final ShortestFindStrategy SHORTEST_FIND_STRATEGY;
    private final boolean moduloAnd;
    private final int moduleMask;
    private final int PARTITION_SHIFT;
    final int PARTITION_MAX_MASK;
    private final MultiSourceQueueImpl[] sourceQueues;
    private volatile int fcheck = 0;
    AtomicInteger partitionHand = new AtomicInteger(0);

    MultiStageQueueImpl(int queueCount, QueueFactory queueFactory, Class<EC> type, EventCreator<EC> creator, TCLoggerProvider loggerProvider, String stageName, int queueSize) {
        super(loggerProvider, stageName, creator, queueSize);
        Assert.eval(queueCount > 0);
        this.PARTITION_SHIFT = queueCount >= 8 ? 2 : 1;
        this.PARTITION_MAX_MASK = (1 << 31 - this.PARTITION_SHIFT) - 1;
        this.sourceQueues = new MultiSourceQueueImpl[queueCount];
        this.createWorkerQueues(queueCount, queueFactory, type, queueSize, stageName);
        if (Integer.bitCount(queueCount) == 1) {
            this.moduloAnd = true;
            this.moduleMask = queueCount - 1;
        } else {
            this.moduloAnd = false;
            this.moduleMask = 0;
        }
    }

    @Override
    AbstractStageQueueImpl.SourceQueue[] getSources() {
        return this.sourceQueues;
    }

    private static ShortestFindStrategy chooseStrategy(ShortestFindStrategy defaultVal) {
        String stratName = System.getProperty(FINDSTRATEGY_PROPNAME, defaultVal.name());
        for (ShortestFindStrategy s : ShortestFindStrategy.values()) {
            if (!s.name().toUpperCase().equals(stratName.toUpperCase())) continue;
            return s;
        }
        System.err.println("Unrecognized 'tc.stagequeueimpl.findstrategy' value: " + stratName + "; using: " + (Object)((Object)defaultVal));
        return defaultVal;
    }

    private int moduloQueueCount(int i) {
        if (this.moduloAnd) {
            return i & this.moduleMask;
        }
        return i % this.sourceQueues.length;
    }

    private void createWorkerQueues(int queueCount, QueueFactory queueFactory, Class<EC> type, int queueSize, String stage) {
        if (queueSize != Integer.MAX_VALUE && queueSize > 0) {
            queueSize = (int)Math.ceil((double)queueSize / (double)queueCount);
        }
        for (int i = 0; i < queueCount; ++i) {
            this.sourceQueues[i] = new MultiSourceQueueImpl(queueFactory.createInstance(type, queueSize), v -> {
                this.fcheck = v;
            }, i);
        }
    }

    @Override
    public Source getSource(int index) {
        return index < 0 || index >= this.sourceQueues.length ? null : this.sourceQueues[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToSink(EC context) {
        Event event;
        Assert.assertNotNull(context);
        if (this.isClosed()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added:" + context + " to:" + this.stageName);
        }
        if ((event = this.createEvent(context)) != null) {
            boolean interrupted = Thread.interrupted();
            int index = this.getSourceQueueFor(context);
            Event wrapper = context.flush() ? new FlushingHandledContext(event, index) : event;
            try {
                while (true) {
                    try {
                        this.updateDepth(this.sourceQueues[index].put(wrapper));
                    }
                    catch (InterruptedException e) {
                        this.logger.debug("StageQueue Add: " + e);
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private int findShortestQueueIndex() {
        switch (SHORTEST_FIND_STRATEGY) {
            case PARTITION: {
                int offset = this.moduloQueueCount(this.nextPartition() << this.PARTITION_SHIFT);
                int min = Integer.MAX_VALUE;
                int can = -1;
                for (int i = 0; i < 1 << this.PARTITION_SHIFT; ++i) {
                    int checkMin = this.sourceQueues[offset].size();
                    if (checkMin < min) {
                        can = offset;
                        min = checkMin;
                    }
                    offset = this.moduloQueueCount(offset + 1);
                }
                return can;
            }
            case BRUTE: {
                int pointer = this.fcheck;
                int min = Integer.MAX_VALUE;
                int can = -1;
                for (int x = 0; x < this.sourceQueues.length; ++x) {
                    int index = this.moduloQueueCount(pointer + x);
                    MultiSourceQueueImpl impl = this.sourceQueues[index];
                    if (impl.isEmpty()) {
                        return index;
                    }
                    int checkMin = impl.size();
                    if (Math.min(min, checkMin) == min) continue;
                    can = index;
                    min = checkMin;
                }
                Assert.assertTrue(can >= 0 && can < this.sourceQueues.length);
                return can;
            }
        }
        throw new IllegalStateException();
    }

    private int nextPartition() {
        int p = this.partitionHand.get();
        int newP = p + 1 & this.PARTITION_MAX_MASK;
        while (!this.partitionHand.compareAndSet(p, newP)) {
            p = this.partitionHand.get();
            newP = p + 1 & this.PARTITION_MAX_MASK;
        }
        return newP;
    }

    private int getSourceQueueFor(EC context) {
        EC multi = context;
        Object schedulingKey = multi.getSchedulingKey();
        if (null == schedulingKey) {
            return this.findShortestQueueIndex();
        }
        return this.hashCodeToArrayIndex(schedulingKey.hashCode(), this.sourceQueues.length);
    }

    private int hashCodeToArrayIndex(int hashcode, int arrayLength) {
        return Math.abs(hashcode % arrayLength);
    }

    @Override
    public String toString() {
        return "StageQueue(" + this.stageName + ")";
    }

    static {
        ShortestFindStrategy strat = ShortestFindStrategy.PARTITION;
        try {
            strat = MultiStageQueueImpl.chooseStrategy(ShortestFindStrategy.PARTITION);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SHORTEST_FIND_STRATEGY = strat;
    }

    private class FlushingHandledContext<T extends EC>
    extends AbstractStageQueueImpl.HandledEvent<EC> {
        private final int offset;
        private int executionCount;

        public FlushingHandledContext(Event context, int offset) {
            super(context);
            this.executionCount = 0;
            this.offset = offset;
        }

        @Override
        public void call() throws EventHandlerException {
            if (++this.executionCount == MultiStageQueueImpl.this.sourceQueues.length) {
                super.call();
            } else {
                boolean interrupted = false;
                try {
                    while (true) {
                        try {
                            MultiStageQueueImpl.this.sourceQueues[MultiStageQueueImpl.this.moduloQueueCount(this.executionCount + this.offset)].put(this);
                        }
                        catch (InterruptedException e) {
                            MultiStageQueueImpl.this.logger.debug("FlushingHandledContext move to next queue: " + e + " : " + (this.executionCount + this.offset) % MultiStageQueueImpl.this.sourceQueues.length);
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    private static final class MultiSourceQueueImpl
    implements AbstractStageQueueImpl.SourceQueue {
        private final Consumer<Integer> hint;
        private final BlockingQueue<Event> queue;
        private final int sourceIndex;

        public MultiSourceQueueImpl(BlockingQueue<Event> queue, Consumer<Integer> hint, int sourceIndex) {
            this.queue = queue;
            this.hint = hint;
            this.sourceIndex = sourceIndex;
        }

        public String toString() {
            return "SourceQueueImpl{" + this.sourceIndex + "size=" + this.queue.size() + '}';
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public Event poll(long timeout) throws InterruptedException {
            Event rv;
            Event event = rv = timeout == 0L ? (Event)this.queue.poll() : this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            if (rv != null) {
                if (this.queue.isEmpty()) {
                    this.hint.accept(this.sourceIndex);
                }
            } else {
                this.hint.accept(this.sourceIndex);
            }
            return rv;
        }

        @Override
        public int put(Event context) throws InterruptedException {
            this.queue.put(context);
            return this.queue.size();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public String getSourceName() {
            return Integer.toString(this.sourceIndex);
        }
    }

    static enum ShortestFindStrategy {
        BRUTE,
        PARTITION;

    }
}

