/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.SchemaUtils;
import org.apache.syncope.client.ui.commons.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class AbstractAttrsWizardStep<S extends SchemaTO>
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 8931397230194043674L;
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    @SpringBean
    protected SchemaRestClient schemaRestClient;
    protected final Comparator<Attr> attrComparator = new AttrComparator();
    protected final AnyTO anyTO;
    protected AnyTO previousObject;
    protected final List<String> whichAttrs;
    protected final Map<String, S> schemas = new LinkedHashMap<String, S>();
    protected final IModel<List<Attr>> attrs;
    protected final List<String> anyTypeClasses;
    protected String fileKey = "";
    protected final AjaxWizard.Mode mode;

    public AbstractAttrsWizardStep(AnyTO anyTO, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichAttrs) {
        this.anyTypeClasses = anyTypeClasses;
        this.attrs = new ListModel(List.of());
        this.setOutputMarkupId(true);
        this.mode = mode;
        this.anyTO = anyTO;
        this.whichAttrs = whichAttrs;
    }

    protected List<Attr> loadAttrs() {
        ArrayList<String> classes = new ArrayList<String>(this.anyTypeClasses);
        classes.addAll(this.anyTypeClassRestClient.list(this.anyTO.getAuxClasses()).stream().map(AnyTypeClassTO::getKey).collect(Collectors.toList()));
        this.setSchemas(classes);
        this.setAttrs();
        return this.getAttrsFromTO();
    }

    protected boolean reoderSchemas() {
        return !this.whichAttrs.isEmpty();
    }

    protected abstract SchemaType getSchemaType();

    protected void setSchemas(List<String> anyTypeClasses) {
        this.setSchemas(anyTypeClasses, this.schemas);
    }

    protected void setSchemas(List<String> anyTypeClasses, Map<String, S> scs) {
        List allSchemas = anyTypeClasses.isEmpty() ? List.of() : this.schemaRestClient.getSchemas(this.getSchemaType(), null, (String[])anyTypeClasses.toArray(String[]::new));
        scs.clear();
        if (!allSchemas.isEmpty() && this.reoderSchemas()) {
            allSchemas.removeAll(allSchemas.stream().filter(schemaTO -> !this.whichAttrs.contains(schemaTO.getKey())).collect(Collectors.toSet()));
        }
        allSchemas.forEach(schemaTO -> scs.put(schemaTO.getKey(), schemaTO));
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (CollectionUtils.isEmpty((Collection)((Collection)this.attrs.getObject()))) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\"); $('#attributes').hide();", this.getString("attribute.empty.list"))));
        }
    }

    protected abstract void setAttrs();

    protected abstract List<Attr> getAttrsFromTO();

    public boolean evaluate() {
        this.attrs.setObject(this.loadAttrs());
        return !((List)this.attrs.getObject()).isEmpty();
    }

    public PageReference getPageReference() {
        return null;
    }

    protected FieldPanel getFieldPanel(final PlainSchemaTO plainSchema) {
        Object panel;
        boolean jexlHelp;
        AttrSchemaType type;
        boolean readOnly;
        boolean required;
        if (this.mode == AjaxWizard.Mode.TEMPLATE) {
            required = false;
            readOnly = false;
            type = AttrSchemaType.String;
            jexlHelp = true;
        } else {
            required = plainSchema.getMandatoryCondition().equalsIgnoreCase("true");
            readOnly = plainSchema.isReadonly();
            type = plainSchema.getType();
            jexlHelp = false;
        }
        switch (type) {
            case Boolean: {
                panel = new AjaxCheckBoxPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), true);
                panel.setRequired(required);
                break;
            }
            case Date: {
                String datePattern = plainSchema.getConversionPattern() == null ? DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.getPattern() : plainSchema.getConversionPattern();
                panel = StringUtils.containsIgnoreCase((CharSequence)datePattern, (CharSequence)"H") ? new AjaxDateTimeFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), FastDateFormat.getInstance((String)datePattern)) : new AjaxDateFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), FastDateFormat.getInstance((String)datePattern));
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), true);
                ((AjaxDropDownChoicePanel)panel).setChoices(SchemaUtils.getEnumeratedValues((PlainSchemaTO)plainSchema));
                if (StringUtils.isNotBlank((CharSequence)plainSchema.getEnumerationKeys())) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;
                        private final Map<String, String> valueMap;
                        {
                            this.valueMap = SchemaUtils.getEnumeratedKeyValues((PlainSchemaTO)plainSchema);
                        }

                        public String getDisplayValue(String value) {
                            return this.valueMap.get(value) == null ? value : this.valueMap.get(value);
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Long: {
                panel = new AjaxNumberFieldPanel.Builder().enableOnChange().build("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), Long.class, (IModel)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Double: {
                panel = new AjaxNumberFieldPanel.Builder().enableOnChange().step((Number)0.1).build("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), Double.class, (IModel)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Binary: {
                final PageReference pageRef = this.getPageReference();
                panel = new BinaryFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), plainSchema.getMimeType(), this.fileKey){
                    private static final long serialVersionUID = -3268213909514986831L;

                    protected PageReference getPageReference() {
                        return pageRef;
                    }
                };
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Encrypted: {
                Object object = panel = "ENCRYPTED_DECODE_CONVERSION_PATTERN".equals(plainSchema.getConversionPattern()) ? new AjaxTextFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), true) : new EncryptedFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), true);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), true);
                if (jexlHelp) {
                    ((AjaxTextFieldPanel)AjaxTextFieldPanel.class.cast(panel)).enableJexlHelp();
                }
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        return panel;
    }

    protected FormComponent<?> checkboxToggle(Attr attr, AbstractFieldPanel<?> panel, boolean isMultivalue) {
        return null;
    }

    protected abstract class PlainSchemas<T>
    extends Schemas {
        private static final long serialVersionUID = 8315035592714180404L;

        public PlainSchemas(String id) {
            super(id);
        }

        protected AbstractFieldPanel<?> setPanel(Map<String, PlainSchemaTO> schemas, ListItem<Attr> item, boolean setReadOnly) {
            Attr attr = (Attr)item.getModelObject();
            PlainSchemaTO schema = schemas.get(attr.getSchema());
            FieldPanel panel = AbstractAttrsWizardStep.this.getFieldPanel(schema);
            if (AbstractAttrsWizardStep.this.mode != AjaxWizard.Mode.TEMPLATE && schema.isMultivalue()) {
                panel = new MultiFieldPanel.Builder(new PropertyModel((Object)attr, "values")).build("panel", schema.getLabel(SyncopeConsoleSession.get().getLocale()), (FieldPanel)FieldPanel.class.cast(panel)).setFormAsMultipart(true);
                ((MultiFieldPanel)((Object)MultiFieldPanel.class.cast(panel))).setReadOnly(schema.isReadonly());
                ((MultiFieldPanel)((Object)MultiFieldPanel.class.cast(panel))).setFormReadOnly(setReadOnly);
            } else {
                ((FieldPanel)FieldPanel.class.cast(panel)).setNewModel(attr.getValues()).setReadOnly(setReadOnly);
            }
            item.add(new Component[]{panel});
            this.setExternalAction(attr, (AbstractFieldPanel<?>)panel);
            return panel;
        }

        protected void setExternalAction(Attr attr, AbstractFieldPanel<?> panel) {
            if (AbstractAttrsWizardStep.this.previousObject == null) {
                return;
            }
            Optional prevAttr = AbstractAttrsWizardStep.this.previousObject.getPlainAttr(attr.getSchema());
            if (prevAttr.map(a -> !ListUtils.isEqualList((Collection)a.getValues().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()), (Collection)attr.getValues().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()))).orElseGet(() -> attr.getValues().stream().anyMatch(StringUtils::isNotBlank)).booleanValue()) {
                List oldValues = prevAttr.map(Attr::getValues).orElse(List.of());
                panel.showExternAction((Component)new LabelInfo("externalAction", oldValues));
            }
        }
    }

    public static class Schemas
    extends Panel {
        private static final long serialVersionUID = -2447602429647965090L;

        public Schemas(String id) {
            super(id);
        }
    }

    private class AttrComparator
    implements Comparator<Attr>,
    Serializable {
        private static final long serialVersionUID = -5105030477767941060L;

        private AttrComparator() {
        }

        @Override
        public int compare(Attr left, Attr right) {
            if (left == null || StringUtils.isEmpty((CharSequence)left.getSchema())) {
                return -1;
            }
            if (right == null || StringUtils.isEmpty((CharSequence)right.getSchema())) {
                return 1;
            }
            if (AbstractAttrsWizardStep.this.reoderSchemas()) {
                int rightIndex;
                int leftIndex = AbstractAttrsWizardStep.this.whichAttrs.indexOf(left.getSchema());
                if (leftIndex > (rightIndex = AbstractAttrsWizardStep.this.whichAttrs.indexOf(right.getSchema()))) {
                    return 1;
                }
                if (leftIndex < rightIndex) {
                    return -1;
                }
                return 0;
            }
            return left.getSchema().compareTo(right.getSchema());
        }
    }
}

