/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import org.apache.syncope.core.provisioning.api.serialization.AbstractValueDeserializer;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.Uid;

class AttributeDeserializer
extends AbstractValueDeserializer<Attribute> {
    AttributeDeserializer() {
    }

    public Attribute deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        String name = tree.get("name").asText();
        List<Object> values = this.doDeserialize(tree.get("value"), jp);
        if (Uid.NAME.equals(name)) {
            return new Uid(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
        }
        if (Name.NAME.equals(name)) {
            return new Name(values.isEmpty() || values.get(0) == null ? null : values.get(0).toString());
        }
        return AttributeBuilder.build((String)name, values);
    }
}

