/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.jackson;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Converter;

final class JacksonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private final ObjectWriter adapter;
    private final MediaType mediaType;

    JacksonRequestBodyConverter(ObjectWriter adapter, MediaType mediaType) {
        this.adapter = adapter;
        this.mediaType = mediaType;
    }

    public RequestBody convert(T value) throws IOException {
        byte[] bytes = this.adapter.writeValueAsBytes(value);
        return RequestBody.create((MediaType)this.mediaType, (byte[])bytes);
    }
}

