/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.pages.Realms;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.console.wizards.any.AnnotatedBeanPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Details<T extends AnyTO>
extends WizardStep {
    private static final long serialVersionUID = -8995647450549098844L;
    protected static final Logger LOG = LoggerFactory.getLogger(Details.class);
    @SpringBean
    protected RealmRestClient realmRestClient;
    protected final PageReference pageRef;
    protected final FieldPanel<String> realm;

    protected static List<RealmTO> getRealmsFromLinks(List<AbstractLink> realmLinks) {
        return realmLinks.stream().map(Component::getDefaultModelObject).filter(RealmTO.class::isInstance).map(RealmTO.class::cast).toList();
    }

    public Details(AnyWrapper<T> wrapper, boolean templateMode, boolean includeStatusPanel, final PageReference pageRef) {
        Fragment fragment;
        this.pageRef = pageRef;
        final List<String> authRealms = SyncopeConsoleSession.get().getAuthRealms();
        AnyTO inner = (AnyTO)wrapper.getInnerObject();
        if (templateMode) {
            this.realm = new AjaxTextFieldPanel("destinationRealm", "destinationRealm", (IModel)new PropertyModel((Object)inner, "realm"), false);
            ((AjaxTextFieldPanel)AjaxTextFieldPanel.class.cast(this.realm)).enableJexlHelp();
            fragment = new Fragment("realmsFragment", "realmsTemplateFragment", (MarkupContainer)this);
        } else {
            final boolean fullRealmsTree = SyncopeWebApplication.get().fullRealmsTree(this.realmRestClient);
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(fullRealmsTree);
            settings.setShowListOnEmptyInput(fullRealmsTree);
            this.realm = new AjaxSearchFieldPanel("destinationRealm", "destinationRealm", (IModel)new PropertyModel((Object)inner, "realm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    List list;
                    Page page = pageRef.getPage();
                    if (page instanceof Realms) {
                        Realms realms = (Realms)page;
                        list = Details.getRealmsFromLinks(realms.getRealmChoicePanel().getLinks());
                    } else {
                        list = (fullRealmsTree ? Details.this.realmRestClient.search(RealmsUtils.buildBaseQuery()) : Details.this.realmRestClient.search(RealmsUtils.buildKeywordQuery(input))).getResult();
                    }
                    return list.stream().map(RealmTO::getFullPath).filter(fullPath -> authRealms.stream().anyMatch(authRealm -> fullPath.startsWith((String)authRealm))).iterator();
                }
            };
            fragment = new Fragment("realmsFragment", "realmsSearchFragment", (MarkupContainer)this);
        }
        fragment.addOrReplace(new Component[]{this.realm});
        this.addOrReplace(new Component[]{fragment});
        this.add(new Component[]{this.getGeneralStatusInformation("generalStatusInformation", inner).setEnabled(includeStatusPanel).setVisible(includeStatusPanel).setRenderBodyOnly(true)});
    }

    public Details<T> disableRealmSpecification() {
        this.realm.setReadOnly(true);
        return this;
    }

    protected AnnotatedBeanPanel getGeneralStatusInformation(String id, T anyTO) {
        return new AnnotatedBeanPanel(id, anyTO);
    }
}

