/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.jws.AccessTokenJWSSigner;

public class AccessTokenDataBinderImpl
implements AccessTokenDataBinder {
    protected final SecurityProperties securityProperties;
    protected final AccessTokenJWSSigner jwsSigner;
    protected final AccessTokenDAO accessTokenDAO;
    protected final ConfParamOps confParamOps;
    protected final EntityFactory entityFactory;
    protected final DefaultCredentialChecker credentialChecker;

    public AccessTokenDataBinderImpl(SecurityProperties securityProperties, AccessTokenJWSSigner jwsSigner, AccessTokenDAO accessTokenDAO, ConfParamOps confParamOps, EntityFactory entityFactory, DefaultCredentialChecker credentialChecker) {
        this.securityProperties = securityProperties;
        this.jwsSigner = jwsSigner;
        this.accessTokenDAO = accessTokenDAO;
        this.confParamOps = confParamOps;
        this.entityFactory = entityFactory;
        this.credentialChecker = credentialChecker;
    }

    protected AccessTokenDataBinder.AccessTokenInfo generateJWT(String tokenId, String subject, long duration, Map<String, Object> claims) {
        this.credentialChecker.checkIsDefaultJWSKeyInUse();
        OffsetDateTime currentTime = OffsetDateTime.now();
        Date issueTime = new Date(currentTime.toInstant().toEpochMilli());
        OffsetDateTime expiration = currentTime.plusMinutes(duration);
        JWTClaimsSet.Builder claimsSet = new JWTClaimsSet.Builder().jwtID(tokenId).subject(subject).issuer(this.securityProperties.getJwtIssuer()).issueTime(issueTime).expirationTime(new Date(expiration.toInstant().toEpochMilli())).notBeforeTime(issueTime);
        claims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)claimsSet).claim(arg_0, arg_1));
        SignedJWT jwt = new SignedJWT(new JWSHeader(this.jwsSigner.getJwsAlgorithm()), claimsSet.build());
        try {
            jwt.sign((JWSSigner)this.jwsSigner);
        }
        catch (JOSEException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAccessToken);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return new AccessTokenDataBinder.AccessTokenInfo(jwt.serialize(), expiration);
    }

    protected AccessToken replace(String subject, Map<String, Object> claims, byte[] authorities, AccessToken accessToken) {
        AccessTokenDataBinder.AccessTokenInfo generated = this.generateJWT(accessToken.getKey(), subject, (Long)this.confParamOps.get(AuthContextUtils.getDomain(), "jwt.lifetime.minutes", (Object)120L, Long.class), claims);
        accessToken.setBody(generated.jwt());
        accessToken.setExpirationTime(generated.expiration());
        accessToken.setOwner(subject);
        if (!this.securityProperties.getAdminUser().equals(accessToken.getOwner())) {
            accessToken.setAuthorities(authorities);
        }
        return (AccessToken)this.accessTokenDAO.save((Entity)accessToken);
    }

    public AccessTokenDataBinder.AccessTokenInfo create(Optional<String> key, String subject, Map<String, Object> claims, byte[] authorities, boolean replace) {
        AccessToken accessToken = this.accessTokenDAO.findByOwner(subject).map(at -> {
            if (replace || at.getExpirationTime() == null || at.getExpirationTime().isBefore(OffsetDateTime.now())) {
                return this.replace(subject, claims, authorities, (AccessToken)at);
            }
            return at;
        }).orElseGet(() -> {
            AccessToken at = (AccessToken)this.entityFactory.newEntity(AccessToken.class);
            at.setKey(key.orElseGet(() -> SecureRandomUtils.generateRandomUUID().toString()));
            return this.replace(subject, claims, authorities, at);
        });
        return new AccessTokenDataBinder.AccessTokenInfo(accessToken.getBody(), accessToken.getExpirationTime());
    }

    public AccessTokenDataBinder.AccessTokenInfo update(AccessToken accessToken, byte[] authorities) {
        SignedJWT jwt;
        this.credentialChecker.checkIsDefaultJWSKeyInUse();
        long duration = (Long)this.confParamOps.get(AuthContextUtils.getDomain(), "jwt.lifetime.minutes", (Object)120L, Long.class);
        OffsetDateTime currentTime = OffsetDateTime.now();
        OffsetDateTime expiration = currentTime.plusMinutes(duration);
        try {
            JWTClaimsSet.Builder claimsSet = new JWTClaimsSet.Builder(SignedJWT.parse((String)accessToken.getBody()).getJWTClaimsSet()).expirationTime(new Date(expiration.toInstant().toEpochMilli()));
            jwt = new SignedJWT(new JWSHeader(this.jwsSigner.getJwsAlgorithm()), claimsSet.build());
            jwt.sign((JWSSigner)this.jwsSigner);
        }
        catch (JOSEException | ParseException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAccessToken);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        String body = jwt.serialize();
        accessToken.setBody(body);
        accessToken.setExpirationTime(expiration);
        if (!this.securityProperties.getAdminUser().equals(accessToken.getOwner())) {
            accessToken.setAuthorities(authorities);
        }
        this.accessTokenDAO.save((Entity)accessToken);
        return new AccessTokenDataBinder.AccessTokenInfo(body, expiration);
    }

    public AccessTokenTO getAccessTokenTO(AccessToken accessToken) {
        AccessTokenTO accessTokenTO = new AccessTokenTO();
        accessTokenTO.setKey(accessToken.getKey());
        accessTokenTO.setBody(accessToken.getBody());
        accessTokenTO.setExpirationTime(accessToken.getExpirationTime());
        accessTokenTO.setOwner(accessToken.getOwner());
        return accessTokenTO;
    }
}

