/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.toolbar;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.wicketstuff.egrid.column.AbstractEditablePropertyColumn;
import org.wicketstuff.egrid.column.IEditableColumn;
import org.wicketstuff.egrid.column.panel.EditablePanel;
import org.wicketstuff.egrid.component.EditableDataTable;
import org.wicketstuff.egrid.component.EditableTableSubmitLink;
import org.wicketstuff.egrid.toolbar.AbstractEditableToolbar;

public abstract class AddRowToolbar<T extends Serializable>
extends AbstractEditableToolbar {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AddRowToolbar.class.getName());
    private IModel<T> rowModel;

    public AddRowToolbar(EditableDataTable<?, ?> table, Class<T> clazz) {
        super(table);
        this.createNewInstance(clazz, null);
        this.add(new Component[]{this.newAddButton("add", (WebMarkupContainer)this), this.newEditorComponents("td")});
    }

    private void createNewInstance(Class<T> clazz, AjaxRequestTarget target) {
        block2: {
            try {
                this.rowModel = Model.of((Serializable)((Serializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.warning(e.toString());
                this.error((Serializable)((Object)this.getInstantiationErrorMessage(clazz)));
                if (target == null) break block2;
                this.onError(target);
            }
        }
    }

    protected EditableTableSubmitLink newAddButton(String id, WebMarkupContainer container) {
        return new EditableTableSubmitLink(id, container){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSuccess(AjaxRequestTarget target) {
                AddRowToolbar.this.onAdd(target, AddRowToolbar.this.rowModel);
                AddRowToolbar.this.createNewInstance(((Serializable)AddRowToolbar.this.rowModel.getObject()).getClass(), target);
                target.add(new Component[]{AddRowToolbar.this.getTable()});
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                AddRowToolbar.this.onError(target);
            }
        };
    }

    protected abstract void onAdd(AjaxRequestTarget var1, IModel<T> var2);

    protected void onError(AjaxRequestTarget target) {
    }

    protected WebMarkupContainer newEditorComponents(String id) {
        final List<IColumn> columns = this.getTable().getColumns().stream().filter(column -> column instanceof IEditableColumn).toList();
        return new Loop(id, columns.size()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(LoopItem item) {
                IColumn column = (IColumn)columns.get(item.getIndex());
                item.add(new Component[]{column instanceof IEditableColumn ? AddRowToolbar.this.getColumnCellPanel("cell", (IEditableColumn)column) : new WebMarkupContainer("cell")});
            }
        };
    }

    protected Component getColumnCellPanel(String id, IEditableColumn editableColumn) {
        EditablePanel panel = editableColumn.createEditablePanel(id);
        if (editableColumn instanceof AbstractEditablePropertyColumn) {
            AbstractEditablePropertyColumn propertyColumn = (AbstractEditablePropertyColumn)editableColumn;
            FormComponent<?> editorComponent = panel.getEditableComponent();
            editorComponent.setDefaultModel((IModel)PropertyModel.of(this.rowModel, (String)propertyColumn.getPropertyExpression()));
        }
        return panel;
    }

    protected String getInstantiationErrorMessage(Class<T> clazz) {
        return this.getString("addRowToolbar.instantiationError").formatted(clazz.getName());
    }
}

