/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.column;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.wicketstuff.egrid.column.IEditableColumn;
import org.wicketstuff.egrid.column.panel.EditablePanel;
import org.wicketstuff.egrid.component.EditableDataTable;

public abstract class AbstractEditablePropertyColumn<T, S>
extends PropertyColumn<T, S>
implements IEditableColumn {
    private static final long serialVersionUID = 1L;

    public AbstractEditablePropertyColumn(IModel<String> displayModel, String propertyExpression) {
        super(displayModel, propertyExpression);
    }

    public AbstractEditablePropertyColumn(IModel<String> displayModel, String propertyExpression, S sortProperty) {
        super(displayModel, sortProperty, propertyExpression);
    }

    public final void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        Item rowItem = (Item)item.findParent(Item.class);
        Boolean currentlyEditing = (Boolean)rowItem.getMetaData(EditableDataTable.EDITING);
        if (currentlyEditing == null || !currentlyEditing.booleanValue() || !this.allowEdit()) {
            item.add(new Component[]{this.newCellContent(componentId, rowModel)});
            return;
        }
        EditablePanel editablePanel = this.createEditablePanel(componentId);
        FormComponent<?> editableComponent = editablePanel.getEditableComponent();
        editableComponent.setDefaultModel(this.getDataModel(rowModel));
        this.addBehaviors(editableComponent);
        item.add(new Component[]{editablePanel});
    }

    protected Component newCellContent(String componentId, IModel<T> rowModel) {
        return new Label(componentId, this.getDataModel(rowModel));
    }

    @Override
    public void addBehaviors(FormComponent<?> editorComponent) {
    }

    protected boolean allowEdit() {
        return true;
    }
}

