/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.event;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JCacheEntryEvent<K, V>
extends CacheEntryEvent<K, V>
implements Iterable<CacheEntryEvent<? extends K, ? extends V>> {
    private static final long serialVersionUID = 1L;
    private final K key;
    private final boolean hasOldValue;
    private final @Nullable V oldValue;
    private final @Nullable V newValue;

    JCacheEntryEvent(Cache<K, V> source, EventType eventType, K key, boolean hasOldValue, @Nullable V oldValue, @Nullable V newValue) {
        super(source, eventType);
        this.key = Objects.requireNonNull(key);
        this.hasOldValue = hasOldValue;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public K getKey() {
        return this.key;
    }

    public @Nullable V getValue() {
        return this.newValue;
    }

    public @Nullable V getOldValue() {
        return this.oldValue;
    }

    public boolean isOldValueAvailable() {
        return this.hasOldValue;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (!clazz.isInstance(this)) {
            throw new IllegalArgumentException("Class " + clazz + " is unknown to this implementation");
        }
        JCacheEntryEvent castedEntry = this;
        return (T)castedEntry;
    }

    @Override
    public Iterator<CacheEntryEvent<? extends K, ? extends V>> iterator() {
        return new Iterator<CacheEntryEvent<? extends K, ? extends V>>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public CacheEntryEvent<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return JCacheEntryEvent.this;
            }
        };
    }
}

