/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Collections;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;

public class RaftUtil {
    public static ApiMessage errorResponse(ApiKeys apiKey, Errors error) {
        switch (apiKey) {
            case VOTE: {
                return new VoteResponseData().setErrorCode(error.code());
            }
            case BEGIN_QUORUM_EPOCH: {
                return new BeginQuorumEpochResponseData().setErrorCode(error.code());
            }
            case END_QUORUM_EPOCH: {
                return new EndQuorumEpochResponseData().setErrorCode(error.code());
            }
            case FETCH: {
                return new FetchResponseData().setErrorCode(error.code());
            }
            case FETCH_SNAPSHOT: {
                return new FetchSnapshotResponseData().setErrorCode(error.code());
            }
        }
        throw new IllegalArgumentException("Received response for unexpected request type: " + apiKey);
    }

    public static FetchRequestData singletonFetchRequest(TopicPartition topicPartition, Uuid topicId, Consumer<FetchRequestData.FetchPartition> partitionConsumer) {
        FetchRequestData.FetchPartition fetchPartition = new FetchRequestData.FetchPartition().setPartition(topicPartition.partition());
        partitionConsumer.accept(fetchPartition);
        FetchRequestData.FetchTopic fetchTopic = new FetchRequestData.FetchTopic().setTopic(topicPartition.topic()).setTopicId(topicId).setPartitions(Collections.singletonList(fetchPartition));
        return new FetchRequestData().setTopics(Collections.singletonList(fetchTopic));
    }

    public static FetchResponseData singletonFetchResponse(TopicPartition topicPartition, Uuid topicId, Errors topLevelError, Consumer<FetchResponseData.PartitionData> partitionConsumer) {
        FetchResponseData.PartitionData fetchablePartition = new FetchResponseData.PartitionData();
        fetchablePartition.setPartitionIndex(topicPartition.partition());
        partitionConsumer.accept(fetchablePartition);
        FetchResponseData.FetchableTopicResponse fetchableTopic = new FetchResponseData.FetchableTopicResponse().setTopic(topicPartition.topic()).setTopicId(topicId).setPartitions(Collections.singletonList(fetchablePartition));
        return new FetchResponseData().setErrorCode(topLevelError.code()).setResponses(Collections.singletonList(fetchableTopic));
    }

    static boolean hasValidTopicPartition(FetchRequestData data, TopicPartition topicPartition, Uuid topicId) {
        return data.topics().size() == 1 && ((FetchRequestData.FetchTopic)data.topics().get(0)).topicId().equals((Object)topicId) && ((FetchRequestData.FetchTopic)data.topics().get(0)).partitions().size() == 1 && ((FetchRequestData.FetchPartition)((FetchRequestData.FetchTopic)data.topics().get(0)).partitions().get(0)).partition() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(FetchResponseData data, TopicPartition topicPartition, Uuid topicId) {
        return data.responses().size() == 1 && ((FetchResponseData.FetchableTopicResponse)data.responses().get(0)).topicId().equals((Object)topicId) && ((FetchResponseData.FetchableTopicResponse)data.responses().get(0)).partitions().size() == 1 && ((FetchResponseData.PartitionData)((FetchResponseData.FetchableTopicResponse)data.responses().get(0)).partitions().get(0)).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(VoteResponseData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && ((VoteResponseData.TopicData)data.topics().get(0)).topicName().equals(topicPartition.topic()) && ((VoteResponseData.TopicData)data.topics().get(0)).partitions().size() == 1 && ((VoteResponseData.PartitionData)((VoteResponseData.TopicData)data.topics().get(0)).partitions().get(0)).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(VoteRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && ((VoteRequestData.TopicData)data.topics().get(0)).topicName().equals(topicPartition.topic()) && ((VoteRequestData.TopicData)data.topics().get(0)).partitions().size() == 1 && ((VoteRequestData.PartitionData)((VoteRequestData.TopicData)data.topics().get(0)).partitions().get(0)).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(BeginQuorumEpochRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && ((BeginQuorumEpochRequestData.TopicData)data.topics().get(0)).topicName().equals(topicPartition.topic()) && ((BeginQuorumEpochRequestData.TopicData)data.topics().get(0)).partitions().size() == 1 && ((BeginQuorumEpochRequestData.PartitionData)((BeginQuorumEpochRequestData.TopicData)data.topics().get(0)).partitions().get(0)).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(BeginQuorumEpochResponseData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && ((BeginQuorumEpochResponseData.TopicData)data.topics().get(0)).topicName().equals(topicPartition.topic()) && ((BeginQuorumEpochResponseData.TopicData)data.topics().get(0)).partitions().size() == 1 && ((BeginQuorumEpochResponseData.PartitionData)((BeginQuorumEpochResponseData.TopicData)data.topics().get(0)).partitions().get(0)).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(EndQuorumEpochRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && ((EndQuorumEpochRequestData.TopicData)data.topics().get(0)).topicName().equals(topicPartition.topic()) && ((EndQuorumEpochRequestData.TopicData)data.topics().get(0)).partitions().size() == 1 && ((EndQuorumEpochRequestData.PartitionData)((EndQuorumEpochRequestData.TopicData)data.topics().get(0)).partitions().get(0)).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(EndQuorumEpochResponseData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && ((EndQuorumEpochResponseData.TopicData)data.topics().get(0)).topicName().equals(topicPartition.topic()) && ((EndQuorumEpochResponseData.TopicData)data.topics().get(0)).partitions().size() == 1 && ((EndQuorumEpochResponseData.PartitionData)((EndQuorumEpochResponseData.TopicData)data.topics().get(0)).partitions().get(0)).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(DescribeQuorumRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && ((DescribeQuorumRequestData.TopicData)data.topics().get(0)).topicName().equals(topicPartition.topic()) && ((DescribeQuorumRequestData.TopicData)data.topics().get(0)).partitions().size() == 1 && ((DescribeQuorumRequestData.PartitionData)((DescribeQuorumRequestData.TopicData)data.topics().get(0)).partitions().get(0)).partitionIndex() == topicPartition.partition();
    }
}

