/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultPasswordValidationService
implements PasswordValidationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPasswordValidationService.class);
    private final CasConfigurationProperties casProperties;
    private final PasswordHistoryService passwordHistoryService;

    @Override
    public boolean isValid(PasswordChangeRequest bean) throws Throwable {
        if (!StringUtils.hasText((String)bean.toPassword())) {
            LOGGER.error("Provided password is blank");
            return false;
        }
        if (bean.getCurrentPassword() != null && bean.toPassword().equals(bean.toCurrentPassword())) {
            LOGGER.error("Provided password cannot be the same as the current password");
            return false;
        }
        if (!bean.toPassword().equals(bean.toConfirmedPassword())) {
            LOGGER.error("Provided password does not match the confirmed password");
            return false;
        }
        if (!this.isAcceptedByPasswordPolicy(bean.toPassword())) {
            LOGGER.error("Provided password does not match the pattern required for password policy");
            return false;
        }
        if (this.passwordHistoryService.exists(bean)) {
            LOGGER.error("Recycled password from password history is not allowed for [{}]", (Object)bean.getUsername());
            return false;
        }
        return this.validatePassword(bean);
    }

    @Override
    public boolean isAcceptedByPasswordPolicy(String password) {
        String policyPattern = this.casProperties.getAuthn().getPm().getCore().getPasswordPolicyPattern();
        LOGGER.debug("Checking provided password against pattern required for password policy: [{}]", (Object)policyPattern);
        return RegexUtils.find((String)policyPattern, (String)password);
    }

    protected boolean validatePassword(PasswordChangeRequest bean) {
        return true;
    }

    @Generated
    public DefaultPasswordValidationService(CasConfigurationProperties casProperties, PasswordHistoryService passwordHistoryService) {
        this.casProperties = casProperties;
        this.passwordHistoryService = passwordHistoryService;
    }
}

