/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.zookeeper;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConfParamOps
implements ConfParamOps {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfParamOps.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected static final String CONF_PATH = "/conf";
    protected final CuratorFramework client;

    protected static String buildConfPath(String ... parts) {
        return "/conf/" + String.join((CharSequence)"/", parts);
    }

    public ZookeeperConfParamOps(CuratorFramework client) {
        this.client = client;
    }

    public Map<String, Object> list(String domain) {
        try {
            if (this.client.checkExists().forPath(ZookeeperConfParamOps.buildConfPath(domain)) == null) {
                this.client.create().creatingParentContainersIfNeeded().forPath(ZookeeperConfParamOps.buildConfPath(domain));
            }
            TreeMap<String, Object> list = new TreeMap<String, Object>();
            for (String child : (List)this.client.getChildren().forPath(ZookeeperConfParamOps.buildConfPath(domain))) {
                list.put(child, MAPPER.readValue((byte[])this.client.getData().forPath(ZookeeperConfParamOps.buildConfPath(domain, child)), Object.class));
            }
            return list;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public <T> T get(String domain, String key, T defaultValue, Class<T> reference) {
        Object value = null;
        try {
            value = MAPPER.readValue((byte[])this.client.getData().forPath(ZookeeperConfParamOps.buildConfPath(domain, key)), reference);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug("Node {} was not found", (Object)ZookeeperConfParamOps.buildConfPath(domain, key));
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    public <T> void set(String domain, String key, T value) {
        if (value == null) {
            this.remove(domain, key);
        } else {
            try {
                if (this.client.checkExists().forPath(ZookeeperConfParamOps.buildConfPath(domain, key)) == null) {
                    this.client.create().creatingParentContainersIfNeeded().forPath(ZookeeperConfParamOps.buildConfPath(domain, key));
                }
                this.client.setData().forPath(ZookeeperConfParamOps.buildConfPath(domain, key), MAPPER.writeValueAsBytes(value));
            }
            catch (Exception e) {
                throw new KeymasterException((Throwable)e);
            }
        }
    }

    public void remove(String domain, String key) {
        try {
            this.client.delete().forPath(ZookeeperConfParamOps.buildConfPath(domain, key));
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }
}

