/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.response;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtCipherExecutor;
import org.apereo.cas.oidc.util.InternalJwtAccessTokenCipherExecutor;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.apereo.cas.token.cipher.RegisteredServiceJwtTicketCipherExecutor;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;

public class OidcRegisteredServiceJwtResponseModeCipherExecutor
extends RegisteredServiceJwtTicketCipherExecutor
implements OidcRegisteredServiceJwtCipherExecutor {
    protected final LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache;
    protected final LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> registeredServiceJsonWebKeystoreCache;
    protected final OidcIssuerService oidcIssuerService;

    public Optional<String> getSigningKey(RegisteredService registeredService) {
        Optional<JsonWebKeySet> jwks = OidcJsonWebKeyStoreUtils.fetchJsonWebKeySetForSigning(registeredService, this, false);
        return jwks.map(keys -> keys.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
    }

    public Optional<String> getEncryptionKey(RegisteredService registeredService) {
        Optional<JsonWebKeySet> jwks = OidcJsonWebKeyStoreUtils.fetchJsonWebKeySetForEncryption(registeredService, this);
        return jwks.map(JsonWebKeySet::toJson);
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherStrategyTypeRegisteredServiceProperty(RegisteredService registeredService) {
        return RegisteredServiceProperty.RegisteredServiceProperties.OIDC_RESPONSE_MODE_JWT_CIPHER_STRATEGY_TYPE;
    }

    protected JwtTicketCipherExecutor createCipherExecutorInstance(String encryptionKey, String signingKey, RegisteredService registeredService) {
        return InternalJwtAccessTokenCipherExecutor.get(signingKey, encryptionKey, registeredService, this);
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherOperationRegisteredServiceSigningEnabledProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.OIDC_RESPONSE_MODE_JWT_CIPHER_SIGNING_ENABLED;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherOperationRegisteredServiceEncryptionEnabledProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.OIDC_RESPONSE_MODE_JWT_CIPHER_ENCRYPTION_ENABLED;
    }

    @Generated
    public OidcRegisteredServiceJwtResponseModeCipherExecutor(LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> registeredServiceJsonWebKeystoreCache, OidcIssuerService oidcIssuerService) {
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.registeredServiceJsonWebKeystoreCache = registeredServiceJsonWebKeystoreCache;
        this.oidcIssuerService = oidcIssuerService;
    }

    @Override
    @Generated
    public LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> getDefaultJsonWebKeystoreCache() {
        return this.defaultJsonWebKeystoreCache;
    }

    @Override
    @Generated
    public LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> getRegisteredServiceJsonWebKeystoreCache() {
        return this.registeredServiceJsonWebKeystoreCache;
    }

    @Override
    @Generated
    public OidcIssuerService getOidcIssuerService() {
        return this.oidcIssuerService;
    }
}

