/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.ValueCodeGenerator;
import org.springframework.aot.generate.ValueCodeGeneratorDelegates;
import org.springframework.beans.factory.config.AutowiredPropertyMarker;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.javapoet.AnnotationSpec;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;

abstract class BeanDefinitionPropertyValueCodeGeneratorDelegates {
    public static final List<ValueCodeGenerator.Delegate> INSTANCES = List.of(new ManagedListDelegate(), new ManagedSetDelegate(), new ManagedMapDelegate(), new LinkedHashMapDelegate(), new BeanReferenceDelegate(), new TypedStringValueDelegate(), new AutowiredPropertyMarkerDelegate());

    BeanDefinitionPropertyValueCodeGeneratorDelegates() {
    }

    private static class ManagedListDelegate
    extends ValueCodeGeneratorDelegates.CollectionDelegate<ManagedList<?>> {
        public ManagedListDelegate() {
            super(ManagedList.class, CodeBlock.of((String)"new $T()", (Object[])new Object[]{ManagedList.class}));
        }
    }

    private static class ManagedSetDelegate
    extends ValueCodeGeneratorDelegates.CollectionDelegate<ManagedSet<?>> {
        public ManagedSetDelegate() {
            super(ManagedSet.class, CodeBlock.of((String)"new $T()", (Object[])new Object[]{ManagedSet.class}));
        }
    }

    private static class ManagedMapDelegate
    implements ValueCodeGenerator.Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of((String)"$T.ofEntries()", (Object[])new Object[]{ManagedMap.class});

        private ManagedMapDelegate() {
        }

        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
            if (value instanceof ManagedMap) {
                ManagedMap managedMap = (ManagedMap)value;
                return this.generateManagedMapCode(valueCodeGenerator, managedMap);
            }
            return null;
        }

        private <K, V> CodeBlock generateManagedMapCode(ValueCodeGenerator valueCodeGenerator, ManagedMap<K, V> managedMap) {
            if (managedMap.isEmpty()) {
                return EMPTY_RESULT;
            }
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.ofEntries(", new Object[]{ManagedMap.class});
            Iterator iterator = managedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                code.add("$T.entry($L,$L)", new Object[]{Map.class, valueCodeGenerator.generateCode(entry.getKey()), valueCodeGenerator.generateCode(entry.getValue())});
                if (!iterator.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }
    }

    private static class LinkedHashMapDelegate
    extends ValueCodeGeneratorDelegates.MapDelegate {
        private LinkedHashMapDelegate() {
        }

        @Nullable
        protected CodeBlock generateMapCode(ValueCodeGenerator valueCodeGenerator, Map<?, ?> map) {
            GeneratedMethods generatedMethods = valueCodeGenerator.getGeneratedMethods();
            if (map instanceof LinkedHashMap && generatedMethods != null) {
                return this.generateLinkedHashMapCode(valueCodeGenerator, generatedMethods, map);
            }
            return super.generateMapCode(valueCodeGenerator, map);
        }

        private CodeBlock generateLinkedHashMapCode(ValueCodeGenerator valueCodeGenerator, GeneratedMethods generatedMethods, Map<?, ?> map) {
            GeneratedMethod generatedMethod = generatedMethods.add("getMap", method -> {
                method.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{\"rawtypes\", \"unchecked\"}", new Object[0]).build());
                method.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
                method.returns(Map.class);
                method.addStatement("$T map = new $T($L)", new Object[]{Map.class, LinkedHashMap.class, map.size()});
                map.forEach((key, value) -> method.addStatement("map.put($L, $L)", new Object[]{valueCodeGenerator.generateCode(key), valueCodeGenerator.generateCode(value)}));
                method.addStatement("return map", new Object[0]);
            });
            return CodeBlock.of((String)"$L()", (Object[])new Object[]{generatedMethod.getName()});
        }
    }

    private static class BeanReferenceDelegate
    implements ValueCodeGenerator.Delegate {
        private BeanReferenceDelegate() {
        }

        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
            RuntimeBeanReference runtimeBeanReference;
            if (value instanceof RuntimeBeanReference && (runtimeBeanReference = (RuntimeBeanReference)value).getBeanType() != null) {
                return CodeBlock.of((String)"new $T($T.class)", (Object[])new Object[]{RuntimeBeanReference.class, runtimeBeanReference.getBeanType()});
            }
            if (value instanceof BeanReference) {
                BeanReference beanReference = (BeanReference)value;
                return CodeBlock.of((String)"new $T($S)", (Object[])new Object[]{RuntimeBeanReference.class, beanReference.getBeanName()});
            }
            return null;
        }
    }

    private static class TypedStringValueDelegate
    implements ValueCodeGenerator.Delegate {
        private TypedStringValueDelegate() {
        }

        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
            if (value instanceof TypedStringValue) {
                TypedStringValue typedStringValue = (TypedStringValue)value;
                return this.generateTypeStringValueCode(valueCodeGenerator, typedStringValue);
            }
            return null;
        }

        private CodeBlock generateTypeStringValueCode(ValueCodeGenerator valueCodeGenerator, TypedStringValue typedStringValue) {
            String value = typedStringValue.getValue();
            if (typedStringValue.hasTargetType()) {
                return CodeBlock.of((String)"new $T($S, $L)", (Object[])new Object[]{TypedStringValue.class, value, valueCodeGenerator.generateCode(typedStringValue.getTargetType())});
            }
            return valueCodeGenerator.generateCode((Object)value);
        }
    }

    private static class AutowiredPropertyMarkerDelegate
    implements ValueCodeGenerator.Delegate {
        private AutowiredPropertyMarkerDelegate() {
        }

        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
            if (value instanceof AutowiredPropertyMarker) {
                return CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{AutowiredPropertyMarker.class});
            }
            return null;
        }
    }
}

