/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public record OAuth20CodeExpirationPolicyBuilder(CasConfigurationProperties casProperties) implements ExpirationPolicyBuilder<OAuth20Code>
{
    private static final long serialVersionUID = -3597980180617072826L;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        OAuthProperties oauth = this.casProperties.getAuthn().getOauth();
        return new OAuth20CodeExpirationPolicy(oauth.getCode().getNumberOfUses(), oauth.getCode().getTimeToKillInSeconds());
    }
}

