/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.suppress.BufferFullStrategy;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;
import org.apache.kafka.streams.kstream.internals.suppress.TimeDefinitions;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.Maybe;
import org.apache.kafka.streams.state.internals.TimeOrderedKeyValueBuffer;

public class KTableSuppressProcessorSupplier<K, V>
implements KTableProcessorSupplier<K, V, K, V> {
    private final SuppressedInternal<K> suppress;
    private final String storeName;
    private final KTableImpl<K, ?, V> parentKTable;

    public KTableSuppressProcessorSupplier(SuppressedInternal<K> suppress, String storeName, KTableImpl<K, ?, V> parentKTable) {
        this.suppress = suppress;
        this.storeName = storeName;
        this.parentKTable = parentKTable;
        parentKTable.enableSendingOldValues(true);
    }

    @Override
    public Processor<K, Change<V>, K, Change<V>> get() {
        return new KTableSuppressProcessor(this.suppress, this.storeName);
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        final KTableValueGetterSupplier<K, V> parentValueGetterSupplier = this.parentKTable.valueGetterSupplier();
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                final KTableValueGetter parentGetter = parentValueGetterSupplier.get();
                return new KTableValueGetter<K, V>(){
                    private TimeOrderedKeyValueBuffer<K, V, Change<V>> buffer;

                    @Override
                    public void init(ProcessorContext<?, ?> context) {
                        parentGetter.init(context);
                        this.buffer = (TimeOrderedKeyValueBuffer)Objects.requireNonNull(context.getStateStore(KTableSuppressProcessorSupplier.this.storeName));
                    }

                    @Override
                    public ValueAndTimestamp<V> get(K key) {
                        Maybe maybeValue = this.buffer.priorValueForBuffered(key);
                        if (maybeValue.isDefined()) {
                            return maybeValue.getNullableValue();
                        }
                        return parentGetter.get(key);
                    }

                    @Override
                    public boolean isVersioned() {
                        return false;
                    }

                    @Override
                    public void close() {
                        parentGetter.close();
                    }
                };
            }

            @Override
            public String[] storeNames() {
                String[] parentStores = parentValueGetterSupplier.storeNames();
                String[] stores = new String[1 + parentStores.length];
                System.arraycopy(parentStores, 0, stores, 1, parentStores.length);
                stores[0] = KTableSuppressProcessorSupplier.this.storeName;
                return stores;
            }
        };
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        return this.parentKTable.enableSendingOldValues(forceMaterialization);
    }

    private static final class KTableSuppressProcessor<K, V>
    extends ContextualProcessor<K, Change<V>, K, Change<V>> {
        private final long maxRecords;
        private final long maxBytes;
        private final long suppressDurationMillis;
        private final TimeDefinitions.TimeDefinition<K> bufferTimeDefinition;
        private final BufferFullStrategy bufferFullStrategy;
        private final boolean safeToDropTombstones;
        private final String storeName;
        private TimeOrderedKeyValueBuffer<K, V, Change<V>> buffer;
        private InternalProcessorContext<K, Change<V>> internalProcessorContext;
        private Sensor suppressionEmitSensor;
        private long observedStreamTime = -1L;

        private KTableSuppressProcessor(SuppressedInternal<K> suppress, String storeName) {
            this.storeName = storeName;
            Objects.requireNonNull(suppress);
            this.maxRecords = suppress.bufferConfig().maxRecords();
            this.maxBytes = suppress.bufferConfig().maxBytes();
            this.suppressDurationMillis = suppress.timeToWaitForMoreEvents().toMillis();
            this.bufferTimeDefinition = suppress.timeDefinition();
            this.bufferFullStrategy = suppress.bufferConfig().bufferFullStrategy();
            this.safeToDropTombstones = suppress.safeToDropTombstones();
        }

        @Override
        public void init(ProcessorContext<K, Change<V>> context) {
            super.init(context);
            this.internalProcessorContext = (InternalProcessorContext)context;
            this.suppressionEmitSensor = ProcessorNodeMetrics.suppressionEmitSensor(Thread.currentThread().getName(), context.taskId().toString(), this.internalProcessorContext.currentNode().name(), this.internalProcessorContext.metrics());
            this.buffer = (TimeOrderedKeyValueBuffer)Objects.requireNonNull(context.getStateStore(this.storeName));
            this.buffer.setSerdesIfNull(new SerdeGetter(context));
        }

        @Override
        public void process(Record<K, Change<V>> record) {
            this.observedStreamTime = Math.max(this.observedStreamTime, record.timestamp());
            this.buffer(record);
            this.enforceConstraints();
        }

        private void buffer(Record<K, Change<V>> record) {
            long bufferTime = this.bufferTimeDefinition.time(this.internalProcessorContext, record.key());
            this.buffer.put(bufferTime, record, this.internalProcessorContext.recordContext());
        }

        private void enforceConstraints() {
            long streamTime = this.observedStreamTime;
            long expiryTime = streamTime - this.suppressDurationMillis;
            this.buffer.evictWhile(() -> this.buffer.minTimestamp() <= expiryTime, this::emit);
            if (this.overCapacity()) {
                switch (this.bufferFullStrategy) {
                    case EMIT: {
                        this.buffer.evictWhile(this::overCapacity, this::emit);
                        return;
                    }
                    case SHUT_DOWN: {
                        throw new StreamsException(String.format("%s buffer exceeded its max capacity. Currently [%d/%d] records and [%d/%d] bytes.", this.internalProcessorContext.currentNode().name(), this.buffer.numRecords(), this.maxRecords, this.buffer.bufferSize(), this.maxBytes));
                    }
                }
                throw new UnsupportedOperationException("The bufferFullStrategy [" + (Object)((Object)this.bufferFullStrategy) + "] is not implemented. This is a bug in Kafka Streams.");
            }
        }

        private boolean overCapacity() {
            return (long)this.buffer.numRecords() > this.maxRecords || this.buffer.bufferSize() > this.maxBytes;
        }

        private void emit(TimeOrderedKeyValueBuffer.Eviction<K, Change<V>> toEmit) {
            if (this.shouldForward(toEmit.value())) {
                ProcessorRecordContext prevRecordContext = this.internalProcessorContext.recordContext();
                this.internalProcessorContext.setRecordContext(toEmit.recordContext());
                try {
                    this.internalProcessorContext.forward(toEmit.record().withTimestamp(toEmit.recordContext().timestamp()).withHeaders(toEmit.recordContext().headers()));
                    this.suppressionEmitSensor.record(1.0, this.internalProcessorContext.currentSystemTimeMs());
                }
                finally {
                    this.internalProcessorContext.setRecordContext(prevRecordContext);
                }
            }
        }

        private boolean shouldForward(Change<V> value) {
            return value.newValue != null || !this.safeToDropTombstones;
        }
    }
}

