/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.profile.UserProfile;

public class DefaultRolesAuthorizationGenerator
implements AuthorizationGenerator {
    private Collection<String> defaultRoles;

    public DefaultRolesAuthorizationGenerator() {
    }

    public DefaultRolesAuthorizationGenerator(Collection<String> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public DefaultRolesAuthorizationGenerator(String[] defaultRoles) {
        this.defaultRoles = defaultRoles != null ? Arrays.asList(defaultRoles) : null;
    }

    @Override
    public Optional<UserProfile> generate(CallContext ctx, UserProfile profile) {
        if (this.defaultRoles != null) {
            profile.addRoles(this.defaultRoles);
        }
        return Optional.of(profile);
    }

    public void setDefaultRoles(String defaultRolesStr) {
        this.defaultRoles = Arrays.asList(defaultRolesStr.split(","));
    }
}

