/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.beans.ComplianceQuery;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.syncope.core.logic.SyncopeLogic;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;

public class UserSelfServiceImpl
extends AbstractService
implements UserSelfService {
    protected final UserLogic logic;
    protected final SyncopeLogic syncopeLogic;

    public UserSelfServiceImpl(UserLogic logic, SyncopeLogic syncopeLogic) {
        this.logic = logic;
        this.syncopeLogic = syncopeLogic;
    }

    public Response create(UserCR createReq) {
        if (!this.syncopeLogic.isSelfRegAllowed()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add("Self registration forbidden by configuration");
            throw sce;
        }
        ProvisioningResult created = this.logic.selfCreate(createReq, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    public Response read() {
        UserLogic.Self self = this.logic.selfRead();
        return Response.ok().header("X-Syncope-Key", (Object)self.user().getKey()).header("X-Syncope-Entitlements", (Object)self.entitlements()).header("X-Syncope-Delegations", (Object)self.delegations()).entity((Object)self.user()).build();
    }

    public Response update(UserUR updateReq) {
        ProvisioningResult updated = this.logic.selfUpdate(updateReq, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response update(UserTO user) {
        UserLogic.Self self = this.logic.selfRead();
        return this.update(AnyOperations.diff((UserTO)user, (UserTO)self.user(), (boolean)false));
    }

    public Response status(StatusR statusR) {
        ProvisioningResult updated = this.logic.selfStatus(statusR, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response delete() {
        ProvisioningResult deleted = this.logic.selfDelete(this.isNullPriorityAsync());
        return this.modificationResponse(deleted);
    }

    public Response mustChangePassword(PasswordPatch password) {
        ProvisioningResult updated = this.logic.mustChangePassword(password, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public void compliance(ComplianceQuery query) {
        this.logic.compliance(query);
    }

    public void requestPasswordReset(String username, String securityAnswer) {
        if (!this.syncopeLogic.isPwdResetAllowed()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add("Password reset forbidden by configuration");
            throw sce;
        }
        this.logic.requestPasswordReset(username, securityAnswer);
    }

    public void confirmPasswordReset(String token, String password) {
        if (!this.syncopeLogic.isPwdResetAllowed()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add("Password reset forbidden by configuration");
            throw sce;
        }
        this.logic.confirmPasswordReset(token, password);
    }
}

