/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup.modify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.ldup.LdUpConstants;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import net.tirasa.connid.bundles.ldup.modify.AbstractLdUpModifyOp;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateDeltaOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;
import org.ldaptive.AttributeModification;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyDnOperation;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.dn.Dn;
import org.ldaptive.handler.ResultPredicate;

public class LdUpUpdateOp
extends AbstractLdUpModifyOp
implements UpdateOp,
UpdateDeltaOp,
UpdateAttributeValuesOp {
    protected static final Log LOG = Log.getLog(LdUpUpdateOp.class);

    public LdUpUpdateOp(LdUpUtils ldUpUtils) {
        super(ldUpUtils);
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        Set<String> groupsBefore;
        AtomicReference<String> dn = new AtomicReference<String>(this.findDn(objectClass, uid));
        AtomicReference prevDn = new AtomicReference();
        Optional<Name> newName = Optional.ofNullable(AttributeUtil.getNameFromAttributes(replaceAttributes)).filter(name -> !((String)dn.get()).equals(name.getNameValue()));
        HashSet<Attribute> updateAttributes = new HashSet<Attribute>(replaceAttributes);
        newName.ifPresent(updateAttributes::remove);
        AbstractLdUpModifyOp.ProcessResult result = this.process(objectClass, updateAttributes);
        Set<String> set = groupsBefore = this.ldUpUtils.isAccount(objectClass) ? this.findGroups(dn.get()) : Set.of();
        if (!result.ldapAttrs.isEmpty()) {
            try {
                ((ModifyOperation)((ModifyOperation.Builder)((ModifyOperation.Builder)ModifyOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((ModifyRequest)ModifyRequest.builder().dn(dn.get()).modifications((Collection)result.ldapAttrs.stream().map(ldapAttr -> new AttributeModification(AttributeModification.Type.REPLACE, ldapAttr)).collect(Collectors.toList())).build());
            }
            catch (LdapException e) {
                throw new ConnectorException("Update error", (Throwable)e);
            }
        }
        newName.ifPresent(name -> {
            Dn newDn = new Dn(name.getNameValue());
            try {
                ((ModifyDnOperation)((ModifyDnOperation.Builder)((ModifyDnOperation.Builder)ModifyDnOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((ModifyDnRequest)ModifyDnRequest.builder().oldDN((String)dn.get()).newRDN(newDn.getRDn().format()).superior(newDn.getParent().format()).delete(true).build());
                prevDn.set((String)dn.get());
                dn.set(name.getNameValue());
            }
            catch (LdapException e) {
                throw new ConnectorException("Rename error from " + dn + " to " + name, (Throwable)e);
            }
        });
        if (this.ldUpUtils.isAccount(objectClass)) {
            Set<String> groupsToRemove;
            Set<String> groupsToAdd;
            this.setPassword(dn.get(), result.passwordValue);
            if (prevDn.get() == null) {
                groupsToAdd = new HashSet<String>(result.groups);
                groupsToAdd.removeAll(groupsBefore);
                groupsToRemove = new HashSet(groupsBefore);
                groupsToRemove.removeAll(result.groups);
            } else {
                groupsToAdd = result.groups;
                groupsToRemove = groupsBefore;
            }
            this.groupMod(dn.get(), groupsToAdd, AttributeModification.Type.ADD);
            this.groupMod(Optional.ofNullable((String)prevDn.get()).orElse(dn.get()), groupsToRemove, AttributeModification.Type.DELETE);
        }
        return this.uid(objectClass, dn.get());
    }

    protected ProcessDeltaResult processDelta(ObjectClass objectClass, Set<AttributeDelta> modifications) {
        ProcessDeltaResult result = new ProcessDeltaResult();
        HashSet groupMembersToAdd = new HashSet();
        HashSet groupMembersToRemove = new HashSet();
        HashSet groupMembersToReplace = new HashSet();
        modifications.forEach(attrDelta -> {
            if (attrDelta.is(Uid.NAME) || attrDelta.is(Name.NAME)) {
                throw new IllegalArgumentException("Do not perform rename via updateDelta, use standard update");
            }
            if ("ldapGroups".equals(attrDelta.getName())) {
                if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                    CollectionUtil.nullAsEmpty((List)attrDelta.getValuesToAdd()).stream().filter(Objects::nonNull).forEach(dn -> result.groupsToAdd.add(dn.toString()));
                    CollectionUtil.nullAsEmpty((List)attrDelta.getValuesToRemove()).stream().filter(Objects::nonNull).forEach(dn -> result.groupsToRemove.add(dn.toString()));
                    CollectionUtil.nullAsEmpty((List)attrDelta.getValuesToReplace()).stream().filter(Objects::nonNull).forEach(dn -> result.groupsToReplace.add(dn.toString()));
                } else {
                    LOG.warn("Skipping {0} because legacy compatibility mode is not set", new Object[]{attrDelta.getName()});
                }
            } else if (PredefinedAttributes.GROUPS_NAME.equals(attrDelta.getName())) {
                if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                    LOG.warn("Skipping {0} because legacy compatibility mode is set", new Object[]{attrDelta.getName()});
                } else {
                    LdUpUpdateOp.process(result.groupsToAdd, (List<Object>)attrDelta.getValuesToAdd());
                    LdUpUpdateOp.process(result.groupsToRemove, (List<Object>)attrDelta.getValuesToRemove());
                    LdUpUpdateOp.process(result.groupsToReplace, (List<Object>)attrDelta.getValuesToReplace());
                }
            } else if (this.ldUpUtils.getConfiguration().getGroupMemberAttribute().equals(attrDelta.getName())) {
                if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                    CollectionUtil.nullAsEmpty((List)attrDelta.getValuesToAdd()).stream().filter(Objects::nonNull).forEach(dn -> groupMembersToAdd.add(dn.toString()));
                    CollectionUtil.nullAsEmpty((List)attrDelta.getValuesToRemove()).stream().filter(Objects::nonNull).forEach(dn -> groupMembersToRemove.add(dn.toString()));
                    CollectionUtil.nullAsEmpty((List)attrDelta.getValuesToReplace()).stream().filter(Objects::nonNull).forEach(dn -> groupMembersToReplace.add(dn.toString()));
                } else {
                    LOG.warn("Skipping {0} because legacy compatibility mode is not set", new Object[]{attrDelta.getName()});
                }
            } else if (LdUpConstants.MEMBERS_ATTR_NAME.equals(attrDelta.getName())) {
                if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                    LOG.warn("Skipping {0} because legacy compatibility mode is set", new Object[]{attrDelta.getName()});
                } else {
                    LdUpUpdateOp.process(groupMembersToAdd, (List<Object>)attrDelta.getValuesToAdd());
                    LdUpUpdateOp.process(groupMembersToRemove, (List<Object>)attrDelta.getValuesToRemove());
                    LdUpUpdateOp.process(groupMembersToReplace, (List<Object>)attrDelta.getValuesToReplace());
                }
            } else if (attrDelta.is(OperationalAttributes.PASSWORD_NAME)) {
                if (!CollectionUtil.isEmpty((Collection)attrDelta.getValuesToReplace())) {
                    result.passwordValue.set(SecurityUtil.decrypt((GuardedString)((GuardedString)attrDelta.getValuesToReplace().get(0))));
                }
            } else {
                this.ldUpUtils.getLdapAttribute(objectClass, attrDelta.getName()).ifPresent(ldapName -> {
                    LdapAttribute ldapAttr;
                    if (!CollectionUtil.isEmpty((Collection)attrDelta.getValuesToAdd())) {
                        ldapAttr = new LdapAttribute(ldapName);
                        LdUpUpdateOp.process(ldapAttr, (List<Object>)attrDelta.getValuesToAdd());
                        result.modifications.add(new AttributeModification(AttributeModification.Type.ADD, ldapAttr));
                    }
                    if (!CollectionUtil.isEmpty((Collection)attrDelta.getValuesToRemove())) {
                        ldapAttr = new LdapAttribute(ldapName);
                        LdUpUpdateOp.process(ldapAttr, (List<Object>)attrDelta.getValuesToRemove());
                        result.modifications.add(new AttributeModification(AttributeModification.Type.DELETE, ldapAttr));
                    }
                    if (!CollectionUtil.isEmpty((Collection)attrDelta.getValuesToReplace())) {
                        ldapAttr = new LdapAttribute(ldapName);
                        LdUpUpdateOp.process(ldapAttr, (List<Object>)attrDelta.getValuesToReplace());
                        result.modifications.add(new AttributeModification(AttributeModification.Type.REPLACE, ldapAttr));
                    }
                });
            }
        });
        if (this.ldUpUtils.isGroup(objectClass)) {
            LdapAttribute members;
            if (!groupMembersToAdd.isEmpty()) {
                members = new LdapAttribute(this.ldUpUtils.getConfiguration().getGroupMemberAttribute());
                members.addStringValues(groupMembersToAdd);
                result.modifications.add(new AttributeModification(AttributeModification.Type.ADD, members));
            }
            if (!groupMembersToRemove.isEmpty()) {
                members = new LdapAttribute(this.ldUpUtils.getConfiguration().getGroupMemberAttribute());
                members.addStringValues(groupMembersToRemove);
                result.modifications.add(new AttributeModification(AttributeModification.Type.DELETE, members));
            }
            if (!groupMembersToReplace.isEmpty()) {
                members = new LdapAttribute(this.ldUpUtils.getConfiguration().getGroupMemberAttribute());
                members.addStringValues(groupMembersToReplace);
                result.modifications.add(new AttributeModification(AttributeModification.Type.REPLACE, members));
            }
        }
        return result;
    }

    public Set<AttributeDelta> updateDelta(ObjectClass objectClass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options) {
        String dn = this.findDn(objectClass, uid);
        ProcessDeltaResult result = this.processDelta(objectClass, modifications);
        if (!result.modifications.isEmpty()) {
            try {
                ((ModifyOperation)((ModifyOperation.Builder)((ModifyOperation.Builder)ModifyOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((ModifyRequest)ModifyRequest.builder().dn(dn).modifications(result.modifications).build());
            }
            catch (LdapException e) {
                throw new ConnectorException("Update error", (Throwable)e);
            }
        }
        if (this.ldUpUtils.isAccount(objectClass)) {
            this.setPassword(dn, result.passwordValue);
            this.groupMod(dn, result.groupsToAdd, AttributeModification.Type.ADD);
            this.groupMod(dn, result.groupsToRemove, AttributeModification.Type.DELETE);
            this.groupMod(dn, result.groupsToReplace, AttributeModification.Type.REPLACE);
        }
        return modifications;
    }

    public Uid addAttributeValues(ObjectClass objectClass, Uid uid, Set<Attribute> valuesToAdd, OperationOptions options) {
        String dn = this.findDn(objectClass, uid);
        AbstractLdUpModifyOp.ProcessResult result = this.process(objectClass, valuesToAdd);
        if (!result.ldapAttrs.isEmpty()) {
            try {
                ((ModifyOperation)((ModifyOperation.Builder)((ModifyOperation.Builder)ModifyOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((ModifyRequest)ModifyRequest.builder().dn(dn).modifications((Collection)result.ldapAttrs.stream().map(ldapAttr -> new AttributeModification(AttributeModification.Type.ADD, ldapAttr)).collect(Collectors.toList())).build());
            }
            catch (LdapException e) {
                throw new ConnectorException("Update error", (Throwable)e);
            }
        }
        if (this.ldUpUtils.isAccount(objectClass)) {
            this.setPassword(dn, result.passwordValue);
            this.groupMod(dn, result.groups, AttributeModification.Type.ADD);
        }
        return this.uid(objectClass, dn);
    }

    public Uid removeAttributeValues(ObjectClass objectClass, Uid uid, Set<Attribute> valuesToRemove, OperationOptions options) {
        String dn = this.findDn(objectClass, uid);
        AbstractLdUpModifyOp.ProcessResult result = this.process(objectClass, valuesToRemove);
        if (!result.ldapAttrs.isEmpty()) {
            try {
                ((ModifyOperation)((ModifyOperation.Builder)((ModifyOperation.Builder)ModifyOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((ModifyRequest)ModifyRequest.builder().dn(dn).modifications((Collection)result.ldapAttrs.stream().map(ldapAttr -> new AttributeModification(AttributeModification.Type.DELETE, ldapAttr)).collect(Collectors.toList())).build());
            }
            catch (LdapException e) {
                throw new ConnectorException("Update error", (Throwable)e);
            }
        }
        if (this.ldUpUtils.isAccount(objectClass)) {
            if (valuesToRemove.stream().anyMatch(attr -> attr.is(OperationalAttributes.PASSWORD_NAME))) {
                try {
                    ((ModifyOperation)((ModifyOperation.Builder)((ModifyOperation.Builder)ModifyOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((ModifyRequest)ModifyRequest.builder().dn(dn).modifications(new AttributeModification[]{new AttributeModification(AttributeModification.Type.DELETE, new LdapAttribute(this.ldUpUtils.getConfiguration().getPasswordAttribute()))}).build());
                }
                catch (LdapException e) {
                    throw new ConnectorException("Remove password error", (Throwable)e);
                }
            }
            this.groupMod(dn, result.groups, AttributeModification.Type.DELETE);
        }
        return this.uid(objectClass, dn);
    }

    protected static class ProcessDeltaResult {
        protected final List<AttributeModification> modifications = new ArrayList<AttributeModification>();
        protected final AtomicReference<String> passwordValue = new AtomicReference();
        protected final Set<String> groupsToAdd = new HashSet<String>();
        protected final Set<String> groupsToRemove = new HashSet<String>();
        protected final Set<String> groupsToReplace = new HashSet<String>();

        protected ProcessDeltaResult() {
        }
    }
}

