/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.parser.sql;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.query.parser.common.InvalidQueryException;
import com.googlecode.cqengine.query.parser.common.ParseResult;
import com.googlecode.cqengine.query.parser.common.QueryParser;
import com.googlecode.cqengine.query.parser.sql.grammar.SQLGrammarLexer;
import com.googlecode.cqengine.query.parser.sql.grammar.SQLGrammarParser;
import com.googlecode.cqengine.query.parser.sql.support.FallbackValueParser;
import com.googlecode.cqengine.query.parser.sql.support.SQLAntlrListener;
import com.googlecode.cqengine.query.parser.sql.support.StringParser;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class SQLParser<O>
extends QueryParser<O> {
    public SQLParser(Class<O> objectType) {
        super(objectType);
        StringParser stringParser = new StringParser();
        super.registerValueParser(String.class, stringParser);
        super.registerFallbackValueParser(new FallbackValueParser(stringParser));
    }

    @Override
    public ParseResult<O> parse(String query) {
        try {
            if (query == null) {
                throw new IllegalArgumentException("Query was null");
            }
            SQLGrammarLexer lexer = new SQLGrammarLexer((CharStream)new ANTLRInputStream(query));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)SYNTAX_ERROR_LISTENER);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SQLGrammarParser parser = new SQLGrammarParser((TokenStream)tokens);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)SYNTAX_ERROR_LISTENER);
            SQLGrammarParser.StartContext queryContext = parser.start();
            ParseTreeWalker walker = new ParseTreeWalker();
            SQLAntlrListener listener = new SQLAntlrListener(this);
            walker.walk(listener, (ParseTree)queryContext);
            return new ParseResult(listener.getParsedQuery(), listener.getQueryOptions());
        }
        catch (InvalidQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidQueryException("Failed to parse query", e);
        }
    }

    public static <O> SQLParser<O> forPojo(Class<O> pojoClass) {
        return new SQLParser<O>(pojoClass);
    }

    public static <O> SQLParser<O> forPojoWithAttributes(Class<O> pojoClass, Map<String, ? extends Attribute<O, ?>> attributes) {
        SQLParser<O> parser = SQLParser.forPojo(pojoClass);
        parser.registerAttributes(attributes);
        return parser;
    }
}

