/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderItemsContainer;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class HtmlHeaderResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    public static final String HEAD = "head";
    public static final String HEADER_ITEMS = "header-items";

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        Page page = container.getPage();
        if (tag.getId().equals("_header_")) {
            return this.newHtmlHeaderContainer(tag.getId(), tag);
        }
        if (tag instanceof WicketTag && ((WicketTag)tag).isHeadTag()) {
            if (container instanceof WebPage) {
                HtmlHeaderContainer header = container.visitChildren(new IVisitor<Component, HtmlHeaderContainer>(){

                    public void component(Component component, IVisit<HtmlHeaderContainer> visit) {
                        if (component instanceof HtmlHeaderContainer) {
                            visit.stop((Object)((HtmlHeaderContainer)component));
                        } else if (!(component instanceof TransparentWebMarkupContainer)) {
                            visit.dontGoDeeper();
                        }
                    }
                });
                if (header == null) {
                    header = this.newHtmlHeaderContainer(tag.getId(), tag);
                    header.add(new WicketHeadContainer());
                    return header;
                }
                WicketHeadContainer wicketHeadContainer = header.visitChildren(new FindWicketHeadContainer());
                if (wicketHeadContainer == null) {
                    wicketHeadContainer = new WicketHeadContainer();
                    header.add(wicketHeadContainer);
                }
                return wicketHeadContainer;
            }
            if (container instanceof HtmlHeaderContainer) {
                WicketHeadContainer header = new WicketHeadContainer();
                return header;
            }
            String pageClassName = page != null ? page.getClass().getName() : "unknown";
            IResourceStream stream = markupStream.getResource();
            String streamName = stream != null ? stream.toString() : "unknown";
            throw new MarkupException("Mis-placed <wicket:head>. <wicket:head> must be outside of <wicket:panel>, <wicket:border>, and <wicket:extend>. Error occurred while rendering page: " + pageClassName + " using markup stream: " + streamName);
        }
        return null;
    }

    protected HtmlHeaderContainer newHtmlHeaderContainer(String id, ComponentTag tag) {
        HtmlHeaderContainer htmlHeaderContainer = HEADER_ITEMS.equalsIgnoreCase(tag.getName()) ? new HtmlHeaderItemsContainer(id) : new HtmlHeaderContainer(id);
        return htmlHeaderContainer;
    }

    private static class WicketHeadContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public WicketHeadContainer() {
            super("_header_");
            this.setRenderBodyOnly(true);
        }
    }

    private static class FindWicketHeadContainer
    implements IVisitor<Component, WicketHeadContainer> {
        private FindWicketHeadContainer() {
        }

        public void component(Component component, IVisit<WicketHeadContainer> visit) {
            if (component instanceof WicketHeadContainer) {
                WicketHeadContainer result = (WicketHeadContainer)component;
                visit.stop((Object)result);
            }
        }
    }
}

