/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractPlainSchemaRepoExt;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

public class PGPlainSchemaRepoExtImpl
extends AbstractPlainSchemaRepoExt {
    protected static final String HAS_ATTRS_QUERY = "SELECT id FROM %TABLE% WHERE plainAttrs::jsonb @> '[{\"schema\":\"%SCHEMA%\"}]'::jsonb ";

    public PGPlainSchemaRepoExtImpl(AnyUtilsFactory anyUtilsFactory, ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        super(anyUtilsFactory, resourceDAO, entityManager);
    }

    @Override
    public boolean hasAttrs(PlainSchema schema) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM ( " + TABLES.stream().map(t -> HAS_ATTRS_QUERY.replace("%TABLE%", (CharSequence)t).replace("%SCHEMA%", schema.getKey())).collect(Collectors.joining(" UNION ")) + ")");
        return ((Number)query.getSingleResult()).intValue() > 0;
    }

    @Override
    public boolean existsPlainAttrUniqueValue(String realmKey, PlainSchema schema, PlainAttrValue attrValue) {
        PlainAttr attr = new PlainAttr();
        attr.setSchema(schema.getKey());
        attr.setUniqueValue(attrValue);
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM Realm WHERE plainAttrs::jsonb @> '" + POJOHelper.serialize(List.of(attr)).replace("'", "''") + "'::jsonb AND id <> ?1");
        query.setParameter(1, (Object)realmKey);
        return ((Number)query.getSingleResult()).intValue() > 0;
    }

    @Override
    public boolean existsPlainAttrUniqueValue(AnyUtils anyUtils, String anyKey, PlainSchema schema, PlainAttrValue attrValue) {
        PlainAttr attr = new PlainAttr();
        attr.setSchema(schema.getKey());
        attr.setUniqueValue(attrValue);
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM " + new SearchSupport(anyUtils.anyTypeKind()).table().name() + " WHERE plainAttrs::jsonb @> '" + POJOHelper.serialize(List.of(attr)).replace("'", "''") + "'::jsonb AND id <> ?1");
        query.setParameter(1, (Object)anyKey);
        return ((Number)query.getSingleResult()).intValue() > 0;
    }
}

