/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.spi.plan.DefaultAuditTrailExecutionPlan;
import org.apereo.cas.audit.spi.plan.DefaultAuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.spi.principal.ChainingAuditPrincipalIdProvider;
import org.apereo.cas.audit.spi.principal.DefaultAuditPrincipalResolver;
import org.apereo.cas.audit.spi.resource.CredentialsAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.resource.LogoutRequestResourceResolver;
import org.apereo.cas.audit.spi.resource.ProtocolSpecificationValidationAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.ServiceAccessEnforcementAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.ServiceAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.resource.TicketValidationResourceResolver;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.configuration.model.core.audit.AuditSlf4jLogProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.apereo.cas.util.text.MessageSanitizer;
import org.apereo.cas.web.flow.CasWebflowCredentialProvider;
import org.apereo.inspektr.audit.AuditTrailManagementAspect;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.FilterAndDelegateAuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.BooleanAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.MessageBundleAwareResourceResolver;
import org.apereo.inspektr.audit.spi.support.NullableReturnValueAuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.ObjectCreationAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.ShortenedReturnValueAsStringAuditResourceResolver;
import org.apereo.inspektr.audit.support.GroovyAuditTrailManager;
import org.apereo.inspektr.audit.support.Slf4jLoggingAuditTrailManager;
import org.apereo.inspektr.common.spi.AuditActionDateProvider;
import org.apereo.inspektr.common.spi.ClientInfoResolver;
import org.apereo.inspektr.common.spi.DefaultClientInfoResolver;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.InMemoryAuditEventRepository;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

@EnableAspectJAutoProxy(proxyTargetClass=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Audit})
@AutoConfiguration
public class CasCoreAuditAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuditAutoConfiguration.class);
    private static final BeanCondition CONDITION_AUDIT = BeanCondition.on((String)"cas.audit.engine.enabled").isTrue().evenIfMissing();

    @Configuration(value="CasCoreAuditExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class CasCoreAuditExecutionPlanConfiguration {
        CasCoreAuditExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"auditTrailExecutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailExecutionPlan auditTrailExecutionPlan(List<AuditTrailExecutionPlanConfigurer> configurers) {
            DefaultAuditTrailExecutionPlan plan = new DefaultAuditTrailExecutionPlan();
            configurers.stream().filter(BeanSupplier::isNotProxy).forEach(cfg -> {
                LOGGER.trace("Configuring audit trail execution plan via [{}]", (Object)cfg.getName());
                cfg.configureAuditTrailExecutionPlan((AuditTrailExecutionPlan)plan);
            });
            return plan;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditTrailExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailExecutionPlanConfigurer casAuditTrailExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (AuditTrailExecutionPlanConfigurer)BeanSupplier.of(AuditTrailExecutionPlanConfigurer.class).when(BeanCondition.on((String)"cas.audit.slf4j.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                AuditSlf4jLogProperties slf4j = casProperties.getAudit().getSlf4j();
                Slf4jLoggingAuditTrailManager manager = new Slf4jLoggingAuditTrailManager();
                manager.setUseSingleLine(slf4j.isUseSingleLine());
                manager.setEntrySeparator(slf4j.getSinglelineSeparator());
                if (!slf4j.getAuditableFields().isEmpty()) {
                    List<AuditTrailManager.AuditableFields> fields = StringUtils.commaDelimitedListToSet((String)slf4j.getAuditableFields()).stream().map(field -> AuditTrailManager.AuditableFields.valueOf((String)field.toUpperCase(Locale.ENGLISH))).toList();
                    manager.setAuditableFields(fields);
                }
                plan.registerAuditTrailManager((AuditTrailManager)manager);
            }).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"casGroovyAuditTrailExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public AuditTrailExecutionPlanConfigurer casGroovyAuditTrailExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (AuditTrailExecutionPlanConfigurer)BeanSupplier.of(AuditTrailExecutionPlanConfigurer.class).when(BeanCondition.on((String)"cas.audit.groovy.template.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> FunctionUtils.doAndHandle(__ -> {
                File templateFile = casProperties.getAudit().getGroovy().getTemplate().getLocation().getFile();
                GroovyAuditTrailManager mgr = new GroovyAuditTrailManager(templateFile, (ApplicationContext)applicationContext);
                plan.registerAuditTrailManager((AuditTrailManager)mgr);
            })).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreAuditResolutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class CasCoreAuditResolutionPlanConfiguration {
        CasCoreAuditResolutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"auditTrailRecordResolutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlan auditTrailRecordResolutionPlan(List<AuditTrailRecordResolutionPlanConfigurer> configurers) {
            DefaultAuditTrailRecordResolutionPlan plan = new DefaultAuditTrailRecordResolutionPlan();
            configurers.stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<AuditTrailRecordResolutionPlanConfigurer>)AnnotationAwareOrderComparator.INSTANCE).forEach(configurer -> {
                LOGGER.trace("Registering audit trail manager [{}]", (Object)configurer.getName());
                configurer.configureAuditTrailRecordResolutionPlan((AuditTrailRecordResolutionPlan)plan);
            });
            return plan;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditResourceResolversResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casAuditResourceResolversResolutionPlanConfigurer(@Qualifier(value="credentialsAsFirstParameterResourceResolver") AuditResourceResolver credentialsAsFirstParameterResourceResolver, @Qualifier(value="nullableReturnValueResourceResolver") AuditResourceResolver nullableReturnValueResourceResolver, @Qualifier(value="messageBundleAwareResourceResolver") AuditResourceResolver messageBundleAwareResourceResolver, @Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver, @Qualifier(value="ticketResourceResolver") AuditResourceResolver ticketResourceResolver, @Qualifier(value="serviceAccessEnforcementAuditResourceResolver") AuditResourceResolver serviceAccessEnforcementAuditResourceResolver, @Qualifier(value="serviceAuditResourceResolver") AuditResourceResolver serviceAuditResourceResolver, @Qualifier(value="ticketValidationResourceResolver") AuditResourceResolver ticketValidationResourceResolver, @Qualifier(value="protocolSpecificationValidationResourceResolver") AuditResourceResolver protocolSpecificationValidationResourceResolver, @Qualifier(value="logoutRequestResourceResolver") AuditResourceResolver logoutRequestResourceResolver) {
            return plan -> {
                plan.registerAuditResourceResolver("AUTHENTICATION_RESOURCE_RESOLVER", credentialsAsFirstParameterResourceResolver);
                plan.registerAuditResourceResolver("AUTHENTICATION_EVENT_RESOURCE_RESOLVER", nullableReturnValueResourceResolver);
                plan.registerAuditResourceResolvers(messageBundleAwareResourceResolver, new String[]{"CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", "CREATE_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER"});
                plan.registerAuditResourceResolvers(ticketResourceResolver, new String[]{"DESTROY_TICKET_RESOURCE_RESOLVER", "DESTROY_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER"});
                plan.registerAuditResourceResolver(serviceAuditResourceResolver, new String[]{"GRANT_SERVICE_TICKET_RESOURCE_RESOLVER", "GRANT_PROXY_TICKET_RESOURCE_RESOLVER"});
                plan.registerAuditResourceResolver("VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER", ticketValidationResourceResolver);
                plan.registerAuditResourceResolver("VALIDATE_PROTOCOL_SPECIFICATION_RESOURCE_RESOLVER", protocolSpecificationValidationResourceResolver);
                plan.registerAuditResourceResolvers(returnValueResourceResolver, new String[]{"SAVE_SERVICE_RESOURCE_RESOLVER", "DELETE_SERVICE_RESOURCE_RESOLVER"});
                plan.registerAuditResourceResolver("SERVICE_ACCESS_ENFORCEMENT_RESOURCE_RESOLVER", serviceAccessEnforcementAuditResourceResolver);
                plan.registerAuditResourceResolver("LOGOUT_RESOURCE_RESOLVER", logoutRequestResourceResolver);
            };
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditActionResolversResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casAuditActionResolversResolutionPlanConfigurer(@Qualifier(value="authenticationActionResolver") AuditActionResolver authenticationActionResolver, @Qualifier(value="objectCreationAuditActionResolver") AuditActionResolver objectCreationAuditActionResolver, @Qualifier(value="defaultAuditActionResolver") AuditActionResolver defaultAuditActionResolver, @Qualifier(value="ticketCreationActionResolver") AuditActionResolver ticketCreationActionResolver, @Qualifier(value="triggeredAuditActionResolver") AuditActionResolver triggeredAuditActionResolver, @Qualifier(value="ticketValidationActionResolver") AuditActionResolver ticketValidationActionResolver, @Qualifier(value="booleanActionResolver") AuditActionResolver booleanActionResolver, @Qualifier(value="logoutAuditActionResolver") AuditActionResolver logoutAuditActionResolver) {
            return plan -> {
                plan.registerAuditActionResolvers(authenticationActionResolver, new String[]{"AUTHENTICATION_RESOLVER", "SAVE_SERVICE_ACTION_RESOLVER"});
                plan.registerAuditActionResolvers(ticketCreationActionResolver, new String[]{"CREATE_PROXY_GRANTING_TICKET_RESOLVER", "GRANT_PROXY_TICKET_RESOLVER", "CREATE_TICKET_GRANTING_TICKET_RESOLVER", "GRANT_SERVICE_TICKET_RESOLVER"});
                plan.registerAuditActionResolver("DELETE_SERVICE_ACTION_RESOLVER", objectCreationAuditActionResolver);
                plan.registerAuditActionResolvers(defaultAuditActionResolver, new String[]{"DESTROY_TICKET_RESOLVER", "DESTROY_PROXY_GRANTING_TICKET_RESOLVER"});
                plan.registerAuditActionResolvers(triggeredAuditActionResolver, new String[]{"AUTHENTICATION_EVENT_ACTION_RESOLVER", "SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER"});
                plan.registerAuditActionResolver("VALIDATE_SERVICE_TICKET_RESOLVER", ticketValidationActionResolver);
                plan.registerAuditActionResolver("VALIDATE_PROTOCOL_SPECIFICATION_RESOLVER", booleanActionResolver);
                plan.registerAuditActionResolver("LOGOUT_ACTION_RESOLVER", logoutAuditActionResolver);
            };
        }
    }

    @Configuration(value="CasCoreAuditManagementConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuditManagementConfiguration {
        CasCoreAuditManagementConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"auditTrailManagementAspect"})
        public AuditTrailManagementAspect auditTrailManagementAspect(@Qualifier(value="defaultAuditActionDateProvider") AuditActionDateProvider defaultAuditActionDateProvider, @Qualifier(value="casAuditClientInfoResolver") ClientInfoResolver casAuditClientInfoResolver, @Qualifier(value="auditTrailRecordResolutionPlan") AuditTrailRecordResolutionPlan auditTrailRecordResolutionPlan, @Qualifier(value="auditablePrincipalResolver") PrincipalResolver auditablePrincipalResolver, @Qualifier(value="filterAndDelegateAuditTrailManager") AuditTrailManager filterAndDelegateAuditTrailManager, CasConfigurationProperties casProperties) {
            AuditEngineProperties audit = casProperties.getAudit().getEngine();
            AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)audit.getAuditFormat().name());
            AuditTrailManagementAspect aspect = new AuditTrailManagementAspect(auditablePrincipalResolver, CollectionUtils.wrapList((Object[])new AuditTrailManager[]{filterAndDelegateAuditTrailManager}), auditTrailRecordResolutionPlan.getAuditActionResolvers(), auditTrailRecordResolutionPlan.getAuditResourceResolvers(), auditTrailRecordResolutionPlan.getAuditPrincipalResolvers(), auditFormat, defaultAuditActionDateProvider);
            aspect.setFailOnAuditFailures(!audit.isIgnoreAuditFailures());
            aspect.setEnabled(casProperties.getAudit().getEngine().isEnabled());
            aspect.setClientInfoResolver(casAuditClientInfoResolver);
            return aspect;
        }

        @Bean
        @ConditionalOnMissingBean(name={"filterAndDelegateAuditTrailManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        protected AuditTrailManager filterAndDelegateAuditTrailManager(ConfigurableApplicationContext applicationContext, @Qualifier(value="auditTrailExecutionPlan") AuditTrailExecutionPlan auditTrailExecutionPlan, CasConfigurationProperties casProperties) {
            return (AuditTrailManager)BeanSupplier.of(AuditTrailManager.class).when(CONDITION_AUDIT.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                AuditEngineProperties audit = casProperties.getAudit().getEngine();
                AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)audit.getAuditFormat().name());
                FilterAndDelegateAuditTrailManager auditManager = new FilterAndDelegateAuditTrailManager((Collection)auditTrailExecutionPlan.getAuditTrailManagers(), audit.getSupportedActions(), audit.getExcludedActions());
                auditManager.setAuditFormat(auditFormat);
                return auditManager;
            }).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditClientInfoResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ClientInfoResolver casAuditClientInfoResolver() {
            return new DefaultClientInfoResolver();
        }
    }

    @Configuration(value="CasCoreAuditEventsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuditEventsConfiguration {
        CasCoreAuditEventsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"inMemoryAuditEventRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditEventRepository inMemoryAuditEventRepository(ConfigurableApplicationContext applicationContext) {
            return (AuditEventRepository)BeanSupplier.of(AuditEventRepository.class).when(CONDITION_AUDIT.given((PropertyResolver)applicationContext.getEnvironment())).supply(InMemoryAuditEventRepository::new).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreAuditActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuditActionsConfiguration {
        CasCoreAuditActionsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultAuditActionDateProvider"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionDateProvider defaultAuditActionDateProvider() {
            return AuditActionDateProvider.utc();
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver defaultAuditActionResolver() {
            return new DefaultAuditActionResolver();
        }

        @Bean
        @ConditionalOnMissingBean(name={"triggeredAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver triggeredAuditActionResolver() {
            return new DefaultAuditActionResolver("_TRIGGERED");
        }

        @Bean
        @ConditionalOnMissingBean(name={"objectCreationAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver objectCreationAuditActionResolver() {
            return new ObjectCreationAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @Bean
        @ConditionalOnMissingBean(name={"booleanActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver booleanActionResolver() {
            return new BooleanAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @ConditionalOnMissingBean(name={"authenticationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver authenticationActionResolver() {
            return new DefaultAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @ConditionalOnMissingBean(name={"ticketCreationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver ticketCreationActionResolver() {
            return new DefaultAuditActionResolver("_CREATED", "_NOT_CREATED");
        }

        @ConditionalOnMissingBean(name={"ticketValidationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver ticketValidationActionResolver() {
            return new DefaultAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @ConditionalOnMissingBean(name={"logoutAuditActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver logoutAuditActionResolver() {
            return new DefaultAuditActionResolver("_SUCCESS", "_FAILED");
        }
    }

    @Configuration(value="CasCoreAuditResourcesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuditResourcesConfiguration {
        CasCoreAuditResourcesConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"credentialsAsFirstParameterResourceResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver credentialsAsFirstParameterResourceResolver(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, CasConfigurationProperties casProperties) {
            return new CredentialsAsFirstParameterResourceResolver(authenticationServiceSelectionPlan, casProperties.getAudit().getEngine());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"protocolSpecificationValidationResourceResolver"})
        public AuditResourceResolver protocolSpecificationValidationResourceResolver(CasConfigurationProperties casProperties) {
            return new ProtocolSpecificationValidationAuditResourceResolver(casProperties);
        }

        @ConditionalOnMissingBean(name={"ticketResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver ticketResourceResolver(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, CasConfigurationProperties casProperties) {
            return new TicketAsFirstParameterResourceResolver(authenticationServiceSelectionPlan, casProperties.getAudit().getEngine());
        }

        @ConditionalOnMissingBean(name={"ticketValidationResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver ticketValidationResourceResolver(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="ticketResourceResolver") AuditResourceResolver ticketResourceResolver, CasConfigurationProperties casProperties) {
            if (casProperties.getAudit().getEngine().isIncludeValidationAssertion()) {
                return new TicketValidationResourceResolver(authenticationServiceSelectionPlan, casProperties.getAudit().getEngine());
            }
            return ticketResourceResolver;
        }

        @ConditionalOnMissingBean(name={"messageBundleAwareResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver messageBundleAwareResourceResolver(@Qualifier(value="messageSanitizer") MessageSanitizer messageSanitizer, ConfigurableApplicationContext applicationContext) {
            MessageBundleAwareResourceResolver resolver = new MessageBundleAwareResourceResolver((ApplicationContext)applicationContext);
            resolver.setResourcePostProcessor(inputs -> (String[])Arrays.stream(inputs).map(arg_0 -> ((MessageSanitizer)messageSanitizer).sanitize(arg_0)).toArray(String[]::new));
            return resolver;
        }

        @ConditionalOnMissingBean(name={"serviceAuditResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver serviceAuditResourceResolver(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, CasConfigurationProperties casProperties) {
            return new ServiceAuditResourceResolver(authenticationServiceSelectionPlan, casProperties.getAudit().getEngine());
        }

        @ConditionalOnMissingBean(name={"returnValueResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver returnValueResourceResolver() {
            return new ShortenedReturnValueAsStringAuditResourceResolver();
        }

        @ConditionalOnMissingBean(name={"nullableReturnValueResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver nullableReturnValueResourceResolver(@Qualifier(value="messageSanitizer") MessageSanitizer messageSanitizer) {
            NullableReturnValueAuditResourceResolver resolver = new NullableReturnValueAuditResourceResolver((AuditResourceResolver)new ShortenedReturnValueAsStringAuditResourceResolver());
            resolver.setResourcePostProcessor(inputs -> (String[])Arrays.stream(inputs).map(arg_0 -> ((MessageSanitizer)messageSanitizer).sanitize(arg_0)).toArray(String[]::new));
            return resolver;
        }

        @ConditionalOnMissingBean(name={"serviceAccessEnforcementAuditResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver serviceAccessEnforcementAuditResourceResolver(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, CasConfigurationProperties casProperties) {
            return new ServiceAccessEnforcementAuditResourceResolver(authenticationServiceSelectionPlan, casProperties.getAudit().getEngine());
        }

        @ConditionalOnMissingBean(name={"logoutRequestResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver logoutRequestResourceResolver() {
            return new LogoutRequestResourceResolver();
        }
    }

    @Configuration(value="CasCoreAuditPrincipalConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreAuditPrincipalConfiguration {
        CasCoreAuditPrincipalConfiguration() {
        }

        @ConditionalOnMissingBean(name={"auditablePrincipalResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolver auditablePrincipalResolver(@Qualifier(value="casWebflowCredentialProvider") CasWebflowCredentialProvider casWebflowCredentialProvider, @Qualifier(value="auditPrincipalIdProvider") AuditPrincipalIdProvider auditPrincipalIdProvider) {
            return new DefaultAuditPrincipalResolver(auditPrincipalIdProvider, casWebflowCredentialProvider);
        }

        @ConditionalOnMissingBean(name={"auditPrincipalIdProvider"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditPrincipalIdProvider auditPrincipalIdProvider(List<AuditPrincipalIdProvider> providers) {
            AnnotationAwareOrderComparator.sortIfNecessary(providers);
            return new ChainingAuditPrincipalIdProvider(providers);
        }
    }
}

