/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;

class ExpungeCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "EXPUNGE";

    ExpungeCommand() {
        super(NAME, "<message-set>");
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        IdRange[] idSet = null;
        if (useUids) {
            idSet = this.parser.parseIdRange(request);
        }
        this.parser.endLine(request);
        if (session.getSelected().isReadonly()) {
            response.commandFailed(this, "Mailbox selected read only.");
        }
        ImapSessionFolder folder = session.getSelected();
        if (this.log.isDebugEnabled() && useUids) {
            this.log.debug("Expunging messages matching uids {} from {}", (Object)IdRange.idRangesToString(idSet), (Object)folder.getFullName());
        }
        if (useUids) {
            folder.expunge(idSet);
        } else {
            folder.expunge();
        }
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }
}

