/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.yubico.core.SessionManager;
import com.yubico.core.WebAuthnCache;
import com.yubico.webauthn.data.ByteArray;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class DefaultSessionManager
implements SessionManager {
    private final WebAuthnCache<ByteArray> sessionIdsToUsers;
    private final WebAuthnCache<ByteArray> usersToSessionIds;

    @Override
    public ByteArray createSession(HttpServletRequest request, @NonNull ByteArray userHandle) {
        if (userHandle == null) {
            throw new NullPointerException("userHandle is marked non-null but is null");
        }
        ByteArray sessionId = this.usersToSessionIds.get(request, userHandle, __ -> SessionManager.generateRandom(32));
        this.sessionIdsToUsers.put(request, sessionId, userHandle);
        return sessionId;
    }

    @Override
    public Optional<ByteArray> getSession(HttpServletRequest request, @NonNull ByteArray sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        return Optional.ofNullable(this.sessionIdsToUsers.getIfPresent(request, sessionId));
    }

    @Generated
    public DefaultSessionManager(WebAuthnCache<ByteArray> sessionIdsToUsers, WebAuthnCache<ByteArray> usersToSessionIds) {
        this.sessionIdsToUsers = sessionIdsToUsers;
        this.usersToSessionIds = usersToSessionIds;
    }
}

