/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.data;

import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.UserIdentity;
import java.time.Instant;
import java.util.SortedSet;
import lombok.Generated;

public final class CredentialRegistration {
    private final UserIdentity userIdentity;
    private final String credentialNickname;
    private final SortedSet<AuthenticatorTransport> transports;
    private final Instant registrationTime;
    private final RegisteredCredential credential;
    private final Attestation attestationMetadata;

    public String getUsername() {
        return this.userIdentity.getName();
    }

    @Generated
    CredentialRegistration(UserIdentity userIdentity, String credentialNickname, SortedSet<AuthenticatorTransport> transports, Instant registrationTime, RegisteredCredential credential, Attestation attestationMetadata) {
        this.userIdentity = userIdentity;
        this.credentialNickname = credentialNickname;
        this.transports = transports;
        this.registrationTime = registrationTime;
        this.credential = credential;
        this.attestationMetadata = attestationMetadata;
    }

    @Generated
    public static CredentialRegistrationBuilder builder() {
        return new CredentialRegistrationBuilder();
    }

    @Generated
    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    @Generated
    public String getCredentialNickname() {
        return this.credentialNickname;
    }

    @Generated
    public SortedSet<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    @Generated
    public Instant getRegistrationTime() {
        return this.registrationTime;
    }

    @Generated
    public RegisteredCredential getCredential() {
        return this.credential;
    }

    @Generated
    public Attestation getAttestationMetadata() {
        return this.attestationMetadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CredentialRegistration)) {
            return false;
        }
        CredentialRegistration other = (CredentialRegistration)o;
        UserIdentity this$userIdentity = this.userIdentity;
        UserIdentity other$userIdentity = other.userIdentity;
        if (this$userIdentity == null ? other$userIdentity != null : !this$userIdentity.equals(other$userIdentity)) {
            return false;
        }
        String this$credentialNickname = this.credentialNickname;
        String other$credentialNickname = other.credentialNickname;
        if (this$credentialNickname == null ? other$credentialNickname != null : !this$credentialNickname.equals(other$credentialNickname)) {
            return false;
        }
        SortedSet<AuthenticatorTransport> this$transports = this.transports;
        SortedSet<AuthenticatorTransport> other$transports = other.transports;
        if (this$transports == null ? other$transports != null : !this$transports.equals(other$transports)) {
            return false;
        }
        Instant this$registrationTime = this.registrationTime;
        Instant other$registrationTime = other.registrationTime;
        if (this$registrationTime == null ? other$registrationTime != null : !((Object)this$registrationTime).equals(other$registrationTime)) {
            return false;
        }
        RegisteredCredential this$credential = this.credential;
        RegisteredCredential other$credential = other.credential;
        if (this$credential == null ? other$credential != null : !this$credential.equals(other$credential)) {
            return false;
        }
        Attestation this$attestationMetadata = this.attestationMetadata;
        Attestation other$attestationMetadata = other.attestationMetadata;
        return !(this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserIdentity $userIdentity = this.userIdentity;
        result = result * 59 + ($userIdentity == null ? 43 : $userIdentity.hashCode());
        String $credentialNickname = this.credentialNickname;
        result = result * 59 + ($credentialNickname == null ? 43 : $credentialNickname.hashCode());
        SortedSet<AuthenticatorTransport> $transports = this.transports;
        result = result * 59 + ($transports == null ? 43 : $transports.hashCode());
        Instant $registrationTime = this.registrationTime;
        result = result * 59 + ($registrationTime == null ? 43 : ((Object)$registrationTime).hashCode());
        RegisteredCredential $credential = this.credential;
        result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
        Attestation $attestationMetadata = this.attestationMetadata;
        result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CredentialRegistration(userIdentity=" + String.valueOf(this.userIdentity) + ", credentialNickname=" + this.credentialNickname + ", transports=" + String.valueOf(this.transports) + ", registrationTime=" + String.valueOf(this.registrationTime) + ", credential=" + String.valueOf(this.credential) + ", attestationMetadata=" + String.valueOf(this.attestationMetadata) + ")";
    }

    @Generated
    public CredentialRegistration withUserIdentity(UserIdentity userIdentity) {
        return this.userIdentity == userIdentity ? this : new CredentialRegistration(userIdentity, this.credentialNickname, this.transports, this.registrationTime, this.credential, this.attestationMetadata);
    }

    @Generated
    public CredentialRegistration withCredentialNickname(String credentialNickname) {
        return this.credentialNickname == credentialNickname ? this : new CredentialRegistration(this.userIdentity, credentialNickname, this.transports, this.registrationTime, this.credential, this.attestationMetadata);
    }

    @Generated
    public CredentialRegistration withTransports(SortedSet<AuthenticatorTransport> transports) {
        return this.transports == transports ? this : new CredentialRegistration(this.userIdentity, this.credentialNickname, transports, this.registrationTime, this.credential, this.attestationMetadata);
    }

    @Generated
    public CredentialRegistration withRegistrationTime(Instant registrationTime) {
        return this.registrationTime == registrationTime ? this : new CredentialRegistration(this.userIdentity, this.credentialNickname, this.transports, registrationTime, this.credential, this.attestationMetadata);
    }

    @Generated
    public CredentialRegistration withCredential(RegisteredCredential credential) {
        return this.credential == credential ? this : new CredentialRegistration(this.userIdentity, this.credentialNickname, this.transports, this.registrationTime, credential, this.attestationMetadata);
    }

    @Generated
    public CredentialRegistration withAttestationMetadata(Attestation attestationMetadata) {
        return this.attestationMetadata == attestationMetadata ? this : new CredentialRegistration(this.userIdentity, this.credentialNickname, this.transports, this.registrationTime, this.credential, attestationMetadata);
    }

    @Generated
    public static class CredentialRegistrationBuilder {
        @Generated
        private UserIdentity userIdentity;
        @Generated
        private String credentialNickname;
        @Generated
        private SortedSet<AuthenticatorTransport> transports;
        @Generated
        private Instant registrationTime;
        @Generated
        private RegisteredCredential credential;
        @Generated
        private Attestation attestationMetadata;

        @Generated
        CredentialRegistrationBuilder() {
        }

        @Generated
        public CredentialRegistrationBuilder userIdentity(UserIdentity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        @Generated
        public CredentialRegistrationBuilder credentialNickname(String credentialNickname) {
            this.credentialNickname = credentialNickname;
            return this;
        }

        @Generated
        public CredentialRegistrationBuilder transports(SortedSet<AuthenticatorTransport> transports) {
            this.transports = transports;
            return this;
        }

        @Generated
        public CredentialRegistrationBuilder registrationTime(Instant registrationTime) {
            this.registrationTime = registrationTime;
            return this;
        }

        @Generated
        public CredentialRegistrationBuilder credential(RegisteredCredential credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public CredentialRegistrationBuilder attestationMetadata(Attestation attestationMetadata) {
            this.attestationMetadata = attestationMetadata;
            return this;
        }

        @Generated
        public CredentialRegistration build() {
            return new CredentialRegistration(this.userIdentity, this.credentialNickname, this.transports, this.registrationTime, this.credential, this.attestationMetadata);
        }

        @Generated
        public String toString() {
            return "CredentialRegistration.CredentialRegistrationBuilder(userIdentity=" + String.valueOf(this.userIdentity) + ", credentialNickname=" + this.credentialNickname + ", transports=" + String.valueOf(this.transports) + ", registrationTime=" + String.valueOf(this.registrationTime) + ", credential=" + String.valueOf(this.credential) + ", attestationMetadata=" + String.valueOf(this.attestationMetadata) + ")";
        }
    }
}

