/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.core.util.resource.locator.IResourceNameIterator;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMenuStringResourceLoader
extends ClassStringResourceLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(DynamicMenuStringResourceLoader.class);
    private final Map<String, Class<?>> keysForPages = new HashMap();

    public DynamicMenuStringResourceLoader() {
        super(DynamicMenuStringResourceLoader.class);
    }

    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        if (key == null || !key.startsWith("menu.")) {
            return null;
        }
        Class<?> pageClass = this.getPage(key);
        if (pageClass == null) {
            return null;
        }
        String path = pageClass.getName().replace('.', '/');
        IResourceNameIterator resourceNameIterator = this.newResourceNameIterator(path, locale, style, variation);
        IPropertiesFactory propertiesFactory = this.getPropertiesFactory();
        while (resourceNameIterator.hasNext()) {
            Properties props = propertiesFactory.load(pageClass, (String)resourceNameIterator.next());
            if (props == null) continue;
            String localeLabel = props.getString(key);
            LOG.debug("Found label \"{}\" for key: {}", (Object)localeLabel, (Object)key);
            return localeLabel;
        }
        return null;
    }

    private Class<?> getPage(String key) {
        return this.keysForPages.get(key);
    }

    public void register(String key, Class<?> pageClass) {
        this.keysForPages.put(key, pageClass);
    }
}

