/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.AbstractSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;

public class SAMLProtocolAndRoleHandler
extends AbstractMessageHandler {
    @NonnullAfterInit
    @NotEmpty
    private String samlProtocol;
    @NonnullAfterInit
    private QName peerRole;
    @Nonnull
    private Class<? extends AbstractSAMLEntityContext> entityContextClass = SAMLPeerEntityContext.class;
    @Nullable
    private ContextDataLookupFunction<MessageContext, ? extends BaseContext> copyContextLookup;

    public void setCopyContextLookup(@Nullable ContextDataLookupFunction<MessageContext, ? extends BaseContext> lookup) {
        this.copyContextLookup = lookup;
    }

    public void setEntityContextClass(@Nonnull Class<? extends AbstractSAMLEntityContext> clazz) {
        this.checkSetterPreconditions();
        this.entityContextClass = (Class)Constraint.isNotNull(clazz, (String)"SAML entity context class may not be null");
    }

    public void setProtocol(@Nonnull @NotEmpty String protocol) {
        this.samlProtocol = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)protocol), (String)"SAML protocol cannot be null");
    }

    public void setRole(@Nonnull QName role) {
        this.peerRole = (QName)Constraint.isNotNull((Object)role, (String)"SAML peer role cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.copyContextLookup == null && (this.samlProtocol == null || this.peerRole == null)) {
            throw new ComponentInitializationException("Either SAML protocol and peer role, or context copy function must be supplied");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        AbstractSAMLEntityContext sourceEntityContext;
        SAMLProtocolContext sourceProtocolContext;
        BaseContext copySource = null;
        if (this.copyContextLookup != null) {
            copySource = (BaseContext)this.copyContextLookup.apply((Object)messageContext);
        }
        if (this.samlProtocol != null) {
            ((SAMLProtocolContext)messageContext.ensureSubcontext(SAMLProtocolContext.class)).setProtocol(this.samlProtocol);
        } else if (copySource != null && (sourceProtocolContext = (SAMLProtocolContext)copySource.getSubcontext(SAMLProtocolContext.class)) != null) {
            ((SAMLProtocolContext)messageContext.ensureSubcontext(SAMLProtocolContext.class)).setProtocol(sourceProtocolContext.getProtocol());
        }
        if (((SAMLProtocolContext)messageContext.ensureSubcontext(SAMLProtocolContext.class)).getProtocol() == null) {
            throw new MessageHandlerException("SAML protocol was not supplied and could not be dynamically resolved");
        }
        if (this.peerRole != null) {
            ((AbstractSAMLEntityContext)messageContext.ensureSubcontext(this.entityContextClass)).setRole(this.peerRole);
        } else if (copySource != null && (sourceEntityContext = (AbstractSAMLEntityContext)copySource.getSubcontext(this.entityContextClass)) != null) {
            ((AbstractSAMLEntityContext)messageContext.ensureSubcontext(this.entityContextClass)).setRole(sourceEntityContext.getRole());
        }
        if (((AbstractSAMLEntityContext)messageContext.ensureSubcontext(this.entityContextClass)).getRole() == null) {
            throw new MessageHandlerException("SAML role was not supplied and could not be dynamically resolved");
        }
    }
}

