/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.support;

import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import java.util.Iterator;

public class ObjectStoreResultSet<O>
extends ResultSet<O> {
    final ObjectStore<O> objectStore;
    final Query<O> query;
    final QueryOptions queryOptions;
    final int retrievalCost;
    final ObjectSet<O> objectSet;

    public ObjectStoreResultSet(ObjectStore<O> objectStore, Query<O> query, QueryOptions queryOptions, int retrievalCost) {
        this.objectStore = objectStore;
        this.query = query;
        this.queryOptions = queryOptions;
        this.retrievalCost = retrievalCost;
        this.objectSet = ObjectSet.fromObjectStore(objectStore, queryOptions);
    }

    @Override
    public Iterator<O> iterator() {
        return this.objectSet.iterator();
    }

    @Override
    public boolean contains(O object) {
        return this.objectStore.contains(object, this.queryOptions);
    }

    @Override
    public boolean matches(O object) {
        return this.query.matches(object, this.queryOptions);
    }

    @Override
    public Query<O> getQuery() {
        return this.query;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public int getRetrievalCost() {
        return this.retrievalCost;
    }

    @Override
    public int getMergeCost() {
        return this.size();
    }

    @Override
    public int size() {
        return this.objectStore.size(this.queryOptions);
    }

    @Override
    public void close() {
        this.objectSet.close();
    }
}

