/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\re\u0001B\u0016-\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003>\u0011\u0019A\u0005\u0001)A\u0005}!I\u0011\n\u0001a\u0001\u0002\u0004%IA\u0013\u0005\n/\u0002\u0001\r\u00111A\u0005\naC\u0011\"\u0019\u0001A\u0002\u0003\u0005\u000b\u0015B&\t\u000f\t\u0004!\u0019!C\u0005G\"1A\u000e\u0001Q\u0001\n\u0011Dq!\u001c\u0001A\u0002\u0013%a\u000eC\u0004s\u0001\u0001\u0007I\u0011B:\t\rU\u0004\u0001\u0015)\u0003p\u0011\u001d1\bA1A\u0005\n]DaA \u0001!\u0002\u0013A\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!!*\u0001\t\u0003\t9\u000bC\u0004\u00022\u0002!\t!a-\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005-\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\ti\u000f\u0001C\u0005\u0003gAq!a<\u0001\t\u0013\t\t\u0010C\u0004\u0002x\u0002!I!!?\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!I!\u0011\u0004\u0001\u0012\u0002\u0013%!1\u0004\u0005\n\u0005c\u0001\u0011\u0013!C\u0005\u0005gAqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003X\u0001!IA!\u0017\t\u0013\t\u0005\u0004!%A\u0005\n\tm\u0001\"\u0003B2\u0001E\u0005I\u0011\u0002B\u000e\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005OB\u0011B!\u001c\u0001#\u0003%IAa\u0007\t\u0013\t=\u0004!%A\u0005\n\tm\u0001b\u0002B9\u0001\u0011\u0005!1\u000f\u0002\u001b\u0019&\u001cHo\u00144gg\u0016$8/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003[9\nQ!\u00193nS:T\u0011aL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0007\u0005\u00024m5\tAG\u0003\u00026]\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\t9DG\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t!\b\u0005\u0002<\u00015\tA&A\u0005u_BL7MT1nKV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!A.\u00198h\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\rM#(/\u001b8h\u0003)!x\u000e]5d\u001d\u0006lW\rI\u0001\u001bi>\u0004\u0018n\u0019(b[\u0016<\u0016\u000e\u001e5DkN$x.\\\"p]\u001aLwm]\u0001\u001ci>\u0004\u0018n\u0019(b[\u0016<\u0016\u000e\u001e5DkN$x.\\\"p]\u001aLwm\u001d\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0002\u0017B\u0011A*V\u0007\u0002\u001b*\u0011QF\u0014\u0006\u0003\u001fB\u000bqa\u00197jK:$8O\u0003\u00020#*\u0011!kU\u0001\u0007CB\f7\r[3\u000b\u0003Q\u000b1a\u001c:h\u0013\t1VJA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\tIv\f\u0005\u0002[;6\t1LC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6L\u0001\u0003V]&$\bb\u00021\b\u0003\u0003\u0005\raS\u0001\u0004q\u0012\n\u0014\u0001D1e[&t7\t\\5f]R\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0003\u0011\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\u000bU$\u0018\u000e\\:\u000b\u0005%\u0004\u0016AB2p[6|g.\u0003\u0002lM\n!A+[7f\u0003%iwnY6US6,\u0007%A\u0004wKJ\u001c\u0018n\u001c8\u0016\u0003=\u0004\"A\u00179\n\u0005E\\&\u0001\u0002\"zi\u0016\f1B^3sg&|gn\u0018\u0013fcR\u0011\u0011\f\u001e\u0005\bA2\t\t\u00111\u0001p\u0003!1XM]:j_:\u0004\u0013A\u00033bi\u00064u\u000e\u001c3feV\t\u0001\u0010E\u0002zyzj\u0011A\u001f\u0006\u0003wn\u000b!bY8mY\u0016\u001cG/[8o\u0013\ti(PA\u0002TKF\f1\u0002Z1uC\u001a{G\u000eZ3sA\u0005)1/\u001a;VaR\u0019\u0011,a\u0001\t\u000f\u0005\u0015\u0001\u00031\u0001\u0002\b\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\n\u0005]QBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0012\u0005M\u0011a\u00026va&$XM\u001d\u0006\u0004\u0003+\u0019\u0016!\u00026v]&$\u0018\u0002BA\r\u0003\u0017\u0011\u0001\u0002V3ti&sgm\u001c\u0015\u0004!\u0005u\u0001\u0003BA\u0005\u0003?IA!!\t\u0002\f\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0015\t\u0014xn[3s)&lW\rF\u0002e\u0003OAq!!\u000b\u0012\u0001\u0004\tY#\u0001\u0005ce>\\WM]%e!\rQ\u0016QF\u0005\u0004\u0003_Y&aA%oi\u0006AA/Z1s\t><h\u000eF\u0001ZQ\r\u0011\u0012q\u0007\t\u0005\u0003\u0013\tI$\u0003\u0003\u0002<\u0005-!!C!gi\u0016\u0014X)Y2i\u0003\u0001\"Xm\u001d;MSN$X*\u0019=US6,7\u000f^1na^KG\u000f[#naRLHj\\4\u0015\u0007e\u000b\t\u0005C\u0004\u0002DM\u0001\r!!\u0012\u0002\rE,xN];n!\u0011\t9%!\u0016\u000f\t\u0005%\u0013\u0011\u000b\t\u0004\u0003\u0017ZVBAA'\u0015\r\ty\u0005M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M3,\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u000b\u0006]#bAA*7\"\u001a1#a\u0017\u0011\t\u0005u\u00131M\u0007\u0003\u0003?RA!!\u0019\u0002\u0010\u00051\u0001/\u0019:b[NLA!!\u001a\u0002`\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000fM\tI'!\u001e\u0002xA!\u00111NA9\u001b\t\tiG\u0003\u0003\u0002p\u0005}\u0013\u0001\u00039s_ZLG-\u001a:\n\t\u0005M\u0014Q\u000e\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005e\u0014QP\u0011\u0003\u0003w\n!A_6\"\u0005\u0005}\u0014!B6sC\u001a$\u0018\u0001\u0005;fgRd\u0015n\u001d;WKJ\u001c\u0018n\u001c81)\rI\u0016Q\u0011\u0005\b\u0003\u0007\"\u0002\u0019AA#Q\r!\u00121\f\u0015\b)\u0005%\u0014QOAFY\t\tI(\u0001\u0013uKN$H\u000b\u001b:fK\u000e{W\u000e\u001d:fgN,GMU3d_J$7/\u00138P]\u0016\u0014\u0015\r^2i)\rI\u0016\u0011\u0013\u0005\b\u0003\u0007*\u0002\u0019AA#Q\r)\u00121\f\u0015\b+\u0005%\u0014QOALY\u0011\tI(! \u0002OQ,7\u000f\u001e+ie\u0016,gj\u001c8D_6\u0004(/Z:tK\u0012\u0014VmY8sINLen\u00148f\u0005\u0006$8\r\u001b\u000b\u00043\u0006u\u0005bBA\"-\u0001\u0007\u0011Q\t\u0015\u0004-\u0005m\u0003f\u0002\f\u0002j\u0005U\u00141\u0015\u0017\u0005\u0003s\ni(\u0001\u0017uKN$H\u000b\u001b:fK:{gnQ8naJ,7o]3e%\u0016\u001cwN\u001d3t\u0013:\u001cV\r]1sCR,')\u0019;dQR\u0019\u0011,!+\t\u000f\u0005\rs\u00031\u0001\u0002F!\u001aq#a\u0017)\u000f]\tI'!\u001e\u000202\"\u0011\u0011PA?\u0003=\"Xm\u001d;UQJ,WMU3d_J$7/\u00138P]\u0016\u0014\u0015\r^2i/&$\b.T3tg\u0006<WmQ8om\u0016\u00148/[8o)\rI\u0016Q\u0017\u0005\b\u0003\u0007B\u0002\u0019AA#Q\rA\u00121\f\u0015\b1\u0005%\u0014QOA^Y\t\tI(\u0001\u001buKN$H\u000b\u001b:fKJ+7m\u001c:eg&s7+\u001a9be\u0006$XMQ1uG\"<\u0016\u000e\u001e5NKN\u001c\u0018mZ3D_:4XM]:j_:$2!WAa\u0011\u001d\t\u0019%\u0007a\u0001\u0003\u000bB3!GA.Q\u001dI\u0012\u0011NA;\u0003\u000fd#!!\u001f\u0002\u0005R,7\u000f\u001e+ie\u0016,'+Z2pe\u0012\u001c\u0018J\\(oK\n\u000bGo\u00195ICZLgn\u001a#jM\u001a,'/\u001a8u\u0007>l\u0007O]3tg&|g\u000eV=qK^KG\u000f[*feZ,'\u000fF\u0002Z\u0003\u001bDq!a\u0011\u001b\u0001\u0004\t)\u0005K\u0002\u001b\u00037BsAGA5\u0003k\n\u0019\u000e\f\u0003\u0002z\u0005u\u0014a\u0012;fgR$\u0006N]3f%\u0016\u001cwN\u001d3t\u0013:\u001cV\r]1sCR,')\u0019;dQ\"\u000bg/\u001b8h\t&4g-\u001a:f]R\u001cu.\u001c9sKN\u001c\u0018n\u001c8UsB,w+\u001b;i'\u0016\u0014h/\u001a:\u0015\u0007e\u000bI\u000eC\u0004\u0002Dm\u0001\r!!\u0012)\u0007m\tY\u0006K\u0004\u001c\u0003S\n)(a8-\t\u0005e\u0014QP\u0001*i\u0016\u001cH\u000f\u00165sK\u0016\u001cu.\u001c9sKN\u001cX\r\u001a*fG>\u0014Hm]%o'\u0016\u0004\u0018M]1uK\n\u000bGo\u00195\u0015\u0007e\u000b)\u000fC\u0004\u0002Dq\u0001\r!!\u0012)\u0007q\tY\u0006K\u0004\u001d\u0003S\n)(a;-\t\u0005e\u0014QP\u0001\u001ag\u0016$X\u000b\u001d$pe2{w-\u00119qK:$G+[7f\u0007\u0006\u001cX-\u0001\u000ede\u0016\fG/Z'fgN\fw-\u001a$pe6\fGO\u0011:pW\u0016\u00148\u000fF\u0002Z\u0003gDa!!>\u001f\u0001\u0004y\u0017!\u0004:fG>\u0014HMV3sg&|g.A\u000bde\u0016\fG/\u001a+pa&\u001cw+\u001b;i\u0007>tg-[4\u0015\u000be\u000bY0a@\t\u000f\u0005ux\u00041\u0001\u0002F\u0005)Ao\u001c9jG\"9!\u0011A\u0010A\u0002\t\r\u0011!\u00029s_B\u001c\b\u0003\u0002B\u0003\u0005\u0017i!Aa\u0002\u000b\u0007\t%!)\u0001\u0003vi&d\u0017\u0002\u0002B\u0007\u0005\u000f\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003E1XM]5gs2K7\u000f^(gMN,Go\u001d\u000b\u00063\nM!Q\u0003\u0005\n\u0003{\u0004\u0003\u0013!a\u0001\u0003\u000bB\u0011Ba\u0006!!\u0003\u0005\r!a\u000b\u00025\u0015D\b/Z2uK\u0012l\u0015\r\u001f+j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;\u00027Y,'/\u001b4z\u0019&\u001cHo\u00144gg\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iB\u000b\u0003\u0002F\t}1F\u0001B\u0011!\u0011\u0011\u0019C!\f\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0005S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-2,\u0001\u0006b]:|G/\u0019;j_:LAAa\f\u0003&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027Y,'/\u001b4z\u0019&\u001cHo\u00144gg\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)D\u000b\u0003\u0002,\t}\u0011a\u0004:v]\u001a+Go\u00195PM\u001a\u001cX\r^:\u0015\u0011\tm\"\u0011\nB&\u0005+\u0002BA!\u0010\u0003D9\u0019AJa\u0010\n\u0007\t\u0005S*A\tMSN$xJ\u001a4tKR\u001c(+Z:vYRLAA!\u0012\u0003H\t)B*[:u\u001f\u001a47/\u001a;t%\u0016\u001cX\u000f\u001c;J]\u001a|'b\u0001B!\u001b\")\u0011j\ta\u0001\u0017\"9!QJ\u0012A\u0002\t=\u0013AC8gMN,Go\u00159fGB\u0019AJ!\u0015\n\u0007\tMSJ\u0001\u0006PM\u001a\u001cX\r^*qK\u000eDq!!@$\u0001\u0004\t)%A\rqe>$WoY3NKN\u001c\u0018mZ3t\u0013:|e.\u001a\"bi\u000eDG#B-\u0003\\\t}\u0003\"\u0003B/IA\u0005\t\u0019AA#\u0003=\u0019w.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007\"CA\u007fIA\u0005\t\u0019AA#\u0003\r\u0002(o\u001c3vG\u0016lUm]:bO\u0016\u001c\u0018J\\(oK\n\u000bGo\u00195%I\u00164\u0017-\u001e7uIE\n1\u0005\u001d:pIV\u001cW-T3tg\u0006<Wm]%o\u001f:,')\u0019;dQ\u0012\"WMZ1vYR$#'\u0001\u0010qe>$WoY3NKN\u001c\u0018mZ3t\u0013:\u001cV\r]1sCR,')\u0019;dQR)\u0011L!\u001b\u0003l!I!QL\u0014\u0011\u0002\u0003\u0007\u0011Q\t\u0005\n\u0003{<\u0003\u0013!a\u0001\u0003\u000b\n\u0001\u0006\u001d:pIV\u001cW-T3tg\u0006<Wm]%o'\u0016\u0004\u0018M]1uK\n\u000bGo\u00195%I\u00164\u0017-\u001e7uIE\n\u0001\u0006\u001d:pIV\u001cW-T3tg\u0006<Wm]%o'\u0016\u0004\u0018M]1uK\n\u000bGo\u00195%I\u00164\u0017-\u001e7uII\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0003\u0005k\u0002B!\u001f?\u0003xA!!\u0011\u0010B@\u001b\t\u0011YHC\u0002\u0003~9\naa]3sm\u0016\u0014\u0018\u0002\u0002BA\u0005w\u00121bS1gW\u0006\u001cuN\u001c4jO\u0002")
public class ListOffsetsIntegrationTest
extends KafkaServerTestHarness {
    private final String topicName;
    private final String topicNameWithCustomConfigs;
    private Admin adminClient;
    private final Time mockTime = new MockTime(1L);
    private byte version = (byte)2;
    private final Seq<String> dataFolder = new .colon.colon((Object)TestUtils.tempDirectory(null, null).getAbsolutePath(), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null).getAbsolutePath(), (List)Nil$.MODULE$));

    private String topicName() {
        return this.topicName;
    }

    private String topicNameWithCustomConfigs() {
        return this.topicNameWithCustomConfigs;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private Time mockTime() {
        return this.mockTime;
    }

    private byte version() {
        return this.version;
    }

    private void version_$eq(byte x$1) {
        this.version = x$1;
    }

    private Seq<String> dataFolder() {
        return this.dataFolder;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopicWithConfig(this.topicName(), new Properties());
        this.adminClient_$eq(Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava()));
    }

    @Override
    public Time brokerTime(int brokerId) {
        return this.mockTime();
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"ListOffsetsAdminClient");
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListMaxTimestampWithEmptyLog(String quorum) {
        ListOffsetsResult.ListOffsetsResultInfo maxTimestampOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.MaxTimestampSpec(), this.topicName());
        Assertions.assertEquals((long)-1L, (long)maxTimestampOffset.offset());
        Assertions.assertEquals((long)-1L, (long)maxTimestampOffset.timestamp());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testListVersion0(String quorum) {
        this.createMessageFormatBrokers((byte)0);
        this.produceMessagesInSeparateBatch("none", this.produceMessagesInSeparateBatch$default$2());
        this.createMessageFormatBrokers((byte)1);
        String x$2 = this.verifyListOffsets$default$1();
        this.verifyListOffsets(x$2, -1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testThreeCompressedRecordsInOneBatch(String quorum) {
        this.produceMessagesInOneBatch("gzip", this.produceMessagesInOneBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        this.produceMessagesInOneBatch("gzip", this.topicNameWithCustomConfigs());
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testThreeNonCompressedRecordsInOneBatch(String quorum) {
        this.produceMessagesInOneBatch("none", this.produceMessagesInOneBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInOneBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testThreeNonCompressedRecordsInSeparateBatch(String quorum) {
        this.produceMessagesInSeparateBatch("none", this.produceMessagesInSeparateBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInSeparateBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 2);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testThreeRecordsInOneBatchWithMessageConversion(String quorum) {
        this.createMessageFormatBrokers((byte)1);
        this.produceMessagesInOneBatch("none", this.produceMessagesInOneBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInOneBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testThreeRecordsInSeparateBatchWithMessageConversion(String quorum) {
        this.createMessageFormatBrokers((byte)1);
        this.produceMessagesInSeparateBatch("none", this.produceMessagesInSeparateBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInSeparateBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 2);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testThreeRecordsInOneBatchHavingDifferentCompressionTypeWithServer(String quorum) {
        Properties props = new Properties();
        props.setProperty("compression.type", "lz4");
        this.createTopicWithConfig(this.topicNameWithCustomConfigs(), props);
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInOneBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testThreeRecordsInSeparateBatchHavingDifferentCompressionTypeWithServer(String quorum) {
        Properties props = new Properties();
        props.setProperty("compression.type", "lz4");
        this.createTopicWithConfig(this.topicNameWithCustomConfigs(), props);
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInSeparateBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 1);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testThreeCompressedRecordsInSeparateBatch(String quorum) {
        this.produceMessagesInSeparateBatch("gzip", this.produceMessagesInSeparateBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        this.produceMessagesInSeparateBatch("gzip", this.topicNameWithCustomConfigs());
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 2);
    }

    private void setUpForLogAppendTimeCase() {
        Properties props = new Properties();
        props.setProperty("message.timestamp.type", "LogAppendTime");
        this.createTopicWithConfig(this.topicNameWithCustomConfigs(), props);
    }

    private void createMessageFormatBrokers(byte recordVersion) {
        this.version_$eq(recordVersion);
        this.recreateBrokers(true, true);
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"ListOffsetsAdminClient");
        this.adminClient_$eq(Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava()));
    }

    private void createTopicWithConfig(String topic, Properties props) {
        this.createTopic(topic, 1, (short)1, props, this.createTopic$default$5(), this.createTopic$default$6());
    }

    /*
     * WARNING - void declaration
     */
    private void verifyListOffsets(String topic, int expectedMaxTimestampOffset) {
        int n;
        this.check$1(topic, expectedMaxTimestampOffset);
        int previousLeader = this.leader$1(topic);
        int newLeader = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.brokers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsIntegrationTest.$anonfun$verifyListOffsets$1(x$2)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 != previousLeader).get());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(new TopicPartition(topic, 0), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(newLeader)))))).all().get();
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((n = this.leader$1(topic)) == newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(30).append("expected leader: ").append(newLeader).append(" but actual: ").append(n).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.check$1(topic, expectedMaxTimestampOffset);
        Set indexFiles = ((IterableOnceOps)this.brokers().flatMap((Function1 & Serializable)x$4 -> x$4.config().logDirs())).toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.killBroker(b.config().brokerId());
            return BoxedUnit.UNIT;
        });
        indexFiles.foreach((Function1 & Serializable)root -> {
            ListOffsetsIntegrationTest.$anonfun$verifyListOffsets$7(topic, root);
            return BoxedUnit.UNIT;
        });
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"ListOffsetsAdminClient");
        this.adminClient_$eq(Admin.create(Collections.singletonMap("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()))));
        this.check$1(topic, expectedMaxTimestampOffset);
    }

    private String verifyListOffsets$default$1() {
        return this.topicName();
    }

    private int verifyListOffsets$default$2() {
        return 1;
    }

    private ListOffsetsResult.ListOffsetsResultInfo runFetchOffsets(Admin adminClient, OffsetSpec offsetSpec, String topic) {
        TopicPartition tp = new TopicPartition(topic, 0);
        return (ListOffsetsResult.ListOffsetsResultInfo)((java.util.Map)adminClient.listOffsets(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetSpec)}))).asJava(), new ListOffsetsOptions()).all().get()).get(tp);
    }

    private void produceMessagesInOneBatch(String compressionType, String topic) {
        .colon.colon records = new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(100L), null, (Object)new byte[10]), (List)new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(999L), null, (Object)new byte[10]), (List)new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(200L), null, (Object)new byte[10]), (List)Nil$.MODULE$)));
        String x$12 = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        int x$52 = -1;
        long x$6 = 60000L;
        long x$7 = 0x100000L;
        int x$8 = Integer.MAX_VALUE;
        int x$9 = 16384;
        int x$10 = 20000;
        SecurityProtocol x$11 = SecurityProtocol.PLAINTEXT;
        None$ x$122 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$12, x$52, x$6, x$7, x$8, Integer.MAX_VALUE, Integer.MAX_VALUE, x$9, compressionType, x$10, x$11, (Option<File>)x$122, (Option<Properties>)x$13, x$14, x$15, x$16);){
            Seq futures = (Seq)records.map((Function1 & Serializable)x$1 -> producer.send(x$1));
            producer.flush();
            futures.foreach((Function1 & Serializable)x$5 -> (RecordMetadata)x$5.get());
        }
    }

    private String produceMessagesInOneBatch$default$1() {
        return "none";
    }

    private String produceMessagesInOneBatch$default$2() {
        return this.topicName();
    }

    private void produceMessagesInSeparateBatch(String compressionType, String topic) {
        .colon.colon records = new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(100L), null, (Object)new byte[10]), (List)Nil$.MODULE$);
        .colon.colon records2 = new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(999L), null, (Object)new byte[10]), (List)Nil$.MODULE$);
        .colon.colon records3 = new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(200L), null, (Object)new byte[10]), (List)Nil$.MODULE$);
        String x$12 = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        int x$3 = -1;
        long x$4 = 60000L;
        long x$5 = 0x100000L;
        int x$62 = Integer.MAX_VALUE;
        int x$72 = 30000;
        int x$82 = 0;
        int x$9 = 16384;
        int x$10 = 20000;
        SecurityProtocol x$11 = SecurityProtocol.PLAINTEXT;
        None$ x$122 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$12, x$3, x$4, x$5, x$62, x$72, x$82, x$9, compressionType, x$10, x$11, (Option<File>)x$122, (Option<Properties>)x$13, x$14, x$15, x$16);){
            ((Seq)records.map((Function1 & Serializable)x$1 -> producer.send(x$1))).foreach((Function1 & Serializable)x$6 -> (RecordMetadata)x$6.get());
            this.mockTime().sleep(100L);
            ((Seq)records2.map((Function1 & Serializable)x$1 -> producer.send(x$1))).foreach((Function1 & Serializable)x$7 -> (RecordMetadata)x$7.get());
            this.mockTime().sleep(100L);
            ((Seq)records3.map((Function1 & Serializable)x$1 -> producer.send(x$1))).foreach((Function1 & Serializable)x$8 -> (RecordMetadata)x$8.get());
        }
    }

    private String produceMessagesInSeparateBatch$default$1() {
        return "none";
    }

    private String produceMessagesInSeparateBatch$default$2() {
        return this.topicName();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)((IterableOps)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Properties props = (Properties)x0$1._1();
                int index = x0$1._2$mcI$sp();
                if (this.version() == 0) {
                    props.setProperty("log.message.format.version", "0.9.0");
                    props.setProperty("inter.broker.protocol.version", "0.9.0");
                }
                if (this.version() == 1) {
                    props.setProperty("log.message.format.version", "0.10.0");
                    props.setProperty("inter.broker.protocol.version", "0.10.0");
                }
                props.setProperty(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "-1");
                props.setProperty("log.dir", (String)this.dataFolder().apply(index));
                return props;
            }
            throw new MatchError(null);
        })).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    private final void check$1(String topic$1, int expectedMaxTimestampOffset$1) {
        ListOffsetsResult.ListOffsetsResultInfo earliestOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.EarliestSpec(), topic$1);
        Assertions.assertEquals((long)0L, (long)earliestOffset.offset());
        ListOffsetsResult.ListOffsetsResultInfo latestOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.LatestSpec(), topic$1);
        Assertions.assertEquals((long)3L, (long)latestOffset.offset());
        ListOffsetsResult.ListOffsetsResultInfo maxTimestampOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.MaxTimestampSpec(), topic$1);
        Assertions.assertEquals((long)expectedMaxTimestampOffset$1, (long)maxTimestampOffset.offset());
        if (this.version() >= 2) {
            Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)maxTimestampOffset.leaderEpoch());
            return;
        }
        Assertions.assertEquals(Optional.empty(), (Object)maxTimestampOffset.leaderEpoch());
    }

    private final int leader$1(String topic$1) {
        return ((TopicPartitionInfo)((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(topic$1)).allTopicNames().get()).get(topic$1)).partitions().get(0)).leader().id();
    }

    public static final /* synthetic */ int $anonfun$verifyListOffsets$1(KafkaBroker x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$verifyListOffsets$3(ListOffsetsIntegrationTest $this, IntRef lastLeader$1, int newLeader$1, String topic$1) {
        lastLeader$1.elem = $this.leader$1(topic$1);
        return lastLeader$1.elem == newLeader$1;
    }

    public static final /* synthetic */ String $anonfun$verifyListOffsets$4(int newLeader$1, IntRef lastLeader$1) {
        return new StringBuilder(30).append("expected leader: ").append(newLeader$1).append(" but actual: ").append(lastLeader$1.elem).toString();
    }

    public static final /* synthetic */ void $anonfun$verifyListOffsets$7(String topic$1, String root) {
        Object[] files = new File(new StringBuilder(3).append(root).append("/").append(topic$1).append("-0").toString()).listFiles();
        if (files != null) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(files), (Function1 & Serializable)f -> {
                if (f.getName().endsWith(".index")) {
                    return BoxesRunTime.boxToBoolean((boolean)f.delete());
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public ListOffsetsIntegrationTest() {
        this.topicName = "foo";
        this.topicNameWithCustomConfigs = "foo2";
    }
}

