/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005=4A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002BB\u0012\u0001A\u0003%\u0001\u0005C\u0004%\u0001\t\u0007I\u0011B\u0013\t\r1\u0002\u0001\u0015!\u0003'\u0011\u001di\u0003A1A\u0005\n9BaA\r\u0001!\u0002\u0013y\u0003\"B\u001a\u0001\t\u0003!\u0004\"B#\u0001\t\u0003!\u0004\"B$\u0001\t\u0003!\u0004\"B%\u0001\t\u0003!\u0004\"B&\u0001\t\u0003a%\u0001\u0007+pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'\u000fV3ti*\u0011q\u0002E\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005q\u0011\u0001\u00032s_.,'/\u00133\u0016\u0003\u0001\u0002\"!F\u0011\n\u0005\t2\"aA%oi\u0006I!M]8lKJLE\rI\u0001\u0007G>tg-[4\u0016\u0003\u0019\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\t\u0002\rM,'O^3s\u0013\tY\u0003FA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u000fI\u0016dW\r^5p]\u000ec\u0017.\u001a8u+\u0005y\u0003CA\u000f1\u0013\t\tdB\u0001\bEK2,G/[8o\u00072LWM\u001c;\u0002\u001f\u0011,G.\u001a;j_:\u001cE.[3oi\u0002\n!\u0003^3ti&s\u0017\u000e^5bY&T\u0018\r^5p]R\tQ\u0007\u0005\u0002\u0016m%\u0011qG\u0006\u0002\u0005+:LG\u000f\u000b\u0002\tsA\u0011!hQ\u0007\u0002w)\u0011A(P\u0001\u0004CBL'B\u0001 @\u0003\u001dQW\u000f]5uKJT!\u0001Q!\u0002\u000b),h.\u001b;\u000b\u0003\t\u000b1a\u001c:h\u0013\t!5H\u0001\u0003UKN$\u0018!\u0005;fgR\u0014\u0015m]5d\t\u0016dW\r^5p]\"\u0012\u0011\"O\u0001\u001ei\u0016\u001cH\u000fR3mKRLwN\\,ji\"\u0014%o\\6fe>3g\r\\5oK\"\u0012!\"O\u0001&i\u0016\u001cHO\u0011:pW\u0016\u0014h)Y5mkJ,\u0017I\u001a;fe\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012D#aC\u001d\u0002\u0017%t\u0017\u000e^\"p]R,\u0007\u0010\u001e\u000b\u0006\u001bBs6.\u001c\t\u0003;9K!a\u0014\b\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000fC\u0003R\u0019\u0001\u0007!+A\u0004ce>\\WM]:\u0011\u0007M[\u0006E\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011qKE\u0001\u0007yI|w\u000e\u001e \n\u0003]I!A\u0017\f\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\u0004'\u0016\f(B\u0001.\u0017\u0011\u0015yF\u00021\u0001a\u0003\u0019!x\u000e]5dgB\u0019\u0011-\u001a5\u000f\u0005\t\u001c\u0007CA+\u0017\u0013\t!g#\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u00141aU3u\u0015\t!g\u0003\u0005\u0002bS&\u0011!n\u001a\u0002\u0007'R\u0014\u0018N\\4\t\u000b1d\u0001\u0019\u0001\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u0015qG\u00021\u0001!\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d")
public class TopicDeletionManagerTest {
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private final DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private DeletionClient deletionClient() {
        return this.deletionClient;
    }

    @Test
    public void testInitialization() {
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar", "baz"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "baz"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsIneligibleForDeletion().toSet());
    }

    @Test
    public void testBasicDeletion() {
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        Set barPartitions = controllerContext.partitionsForTopic("bar");
        scala.collection.immutable.Set barReplicas = controllerContext.replicasForPartition(barPartitions).toSet();
        replicaStateMachine.clear();
        partitionStateMachine.clear();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)barPartitions, (Object)controllerContext.partitionsInState("bar", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)barReplicas, (Object)controllerContext.replicasInState("bar", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate((Set)fooPartitions.$plus$plus((IterableOnce)barPartitions));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas.$plus$plus((IterableOnce)barReplicas));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletion$1(x$1))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("bar"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletion$2(x$2))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((int)1, (int)partitionStateMachine.stateChangesCalls((PartitionState)OfflinePartition$.MODULE$));
        Assertions.assertEquals((int)1, (int)partitionStateMachine.stateChangesCalls((PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)OfflineReplica$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletionWithBrokerOffline() {
        void var13_12;
        void var12_11;
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testDeletionWithBrokerOffline$1(failedBrokerId, x$3)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
        replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)var12_11.toSeq(), (ReplicaState)OfflineReplica$.MODULE$);
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)var13_12);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)OfflineReplica$.MODULE$));
        controllerContext.addLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
        deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        deletionManager.completeReplicaDeletion((Set)var12_11);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testDeletionWithBrokerOffline$2(x$5))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerFailureAfterDeletionStarted() {
        void var13_12;
        void var12_11;
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBrokerFailureAfterDeletionStarted$1(failedBrokerId, x$6)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
        deletionManager.failReplicaDeletion((Set)var12_11);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        controllerContext.addLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
        deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        deletionManager.completeReplicaDeletion((Set)var13_12);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
    }

    public ControllerContext initContext(scala.collection.immutable.Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor) {
        ControllerContext context = new ControllerContext();
        scala.collection.immutable.Map brokerEpochs = ((IterableOnceOps)brokers.map((Function1 & Serializable)brokerId -> TopicDeletionManagerTest.$anonfun$initContext$1(BoxesRunTime.unboxToInt((Object)brokerId)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        context.setLiveBrokers((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1 & Serializable)topic -> {
            TopicDeletionManagerTest.$anonfun$initContext$2(numPartitions, replicationFactor, brokers, leaderIndex, context, topic);
            return BoxedUnit.UNIT;
        });
        return context;
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletion$1(PartitionAndReplica x$1) {
        String string = x$1.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletion$2(PartitionAndReplica x$2) {
        String string = x$2.topic();
        String string2 = "bar";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionWithBrokerOffline$1(int failedBrokerId$1, PartitionAndReplica x$3) {
        return x$3.replica() == failedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionWithBrokerOffline$2(PartitionAndReplica x$5) {
        String string = x$5.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerFailureAfterDeletionStarted$1(int failedBrokerId$2, PartitionAndReplica x$6) {
        return x$6.replica() == failedBrokerId$2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$initContext$1(int brokerId) {
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(brokerId, (Seq)new .colon.colon((Object)endpoint, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    public static final /* synthetic */ void $anonfun$initContext$2(int numPartitions$1, int replicationFactor$1, scala.collection.immutable.Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$1, String topic) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> {
            TopicPartition partition = new TopicPartition(topic, partitionId);
            IndexedSeq replicas = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), replicationFactor$1).map((Function1)(JFunction1.mcII.sp & Serializable)i -> BoxesRunTime.unboxToInt((Object)brokers$1.apply((i + leaderIndex$1.elem) % brokers$1.size())));
            context$1.updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas));
            ++leaderIndex$1.elem;
        });
    }

    public TopicDeletionManagerTest() {
        this.brokerId = 1;
    }
}

