/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow;

import com.yubico.core.RegistrationStorage;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.webauthn.WebAuthnMultifactorAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WebAuthnAccountCheckRegistrationAction
extends AbstractMultifactorAuthenticationAction<WebAuthnMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnAccountCheckRegistrationAction.class);
    private final RegistrationStorage webAuthnCredentialRepository;

    protected Event doExecuteInternal(RequestContext requestContext) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
        LOGGER.trace("Checking registration record for [{}]", (Object)principal.getId());
        Collection registrations = this.webAuthnCredentialRepository.getRegistrationsByUsername(principal.getId());
        if (!registrations.isEmpty()) {
            return this.success();
        }
        return new EventFactorySupport().event((Object)this, "register");
    }

    @Generated
    public WebAuthnAccountCheckRegistrationAction(RegistrationStorage webAuthnCredentialRepository) {
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
    }
}

