/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.IndexAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.config.AbstractEvaluationContextFactoryBean;
import org.springframework.lang.Nullable;

public class IntegrationEvaluationContextFactoryBean
extends AbstractEvaluationContextFactoryBean
implements FactoryBean<StandardEvaluationContext> {
    @Nullable
    private TypeLocator typeLocator;
    private BeanResolver beanResolver;

    public void setTypeLocator(TypeLocator typeLocator) {
        this.typeLocator = typeLocator;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null) {
            this.beanResolver = new BeanFactoryResolver((BeanFactory)applicationContext);
            if (this.typeLocator == null) {
                this.typeLocator = new StandardTypeLocator(applicationContext.getClassLoader());
            }
        }
        this.initialize("integrationEvaluationContext");
    }

    public StandardEvaluationContext getObject() {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        if (this.typeLocator != null) {
            evaluationContext.setTypeLocator(this.typeLocator);
        }
        evaluationContext.setBeanResolver(this.beanResolver);
        evaluationContext.setTypeConverter(this.getTypeConverter());
        for (PropertyAccessor propertyAccessor : this.getPropertyAccessors().values()) {
            evaluationContext.addPropertyAccessor(propertyAccessor);
        }
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        for (IndexAccessor indexAccessor : this.getIndexAccessors().values()) {
            evaluationContext.addIndexAccessor(indexAccessor);
        }
        for (Map.Entry entry : this.getFunctions().entrySet()) {
            evaluationContext.registerFunction((String)entry.getKey(), (Method)entry.getValue());
        }
        return evaluationContext;
    }

    public Class<?> getObjectType() {
        return StandardEvaluationContext.class;
    }
}

