/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceTaskParseHandler<T extends ServiceTask>
extends AbstractActivityBpmnParseHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceTaskParseHandler.class);

    @Override
    protected void executeParse(BpmnParse bpmnParse, T serviceTask) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            if ("mail".equalsIgnoreCase(serviceTask.getType())) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior((ServiceTask)serviceTask));
            } else if ("camel".equalsIgnoreCase(serviceTask.getType())) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior((ServiceTask)serviceTask));
            } else if ("shell".equalsIgnoreCase(serviceTask.getType())) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createShellActivityBehavior((ServiceTask)serviceTask));
            } else if ("dmn".equalsIgnoreCase(serviceTask.getType())) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createDmnActivityBehavior((ServiceTask)serviceTask));
            } else if ("http".equalsIgnoreCase(serviceTask.getType())) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createHttpActivityBehavior((ServiceTask)serviceTask));
            } else if ("delegateExpression".equalsIgnoreCase(serviceTask.getImplementationType())) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskDelegateExpressionActivityBehavior((ServiceTask)serviceTask));
            } else if ("expression".equalsIgnoreCase(serviceTask.getImplementationType())) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskExpressionActivityBehavior((ServiceTask)serviceTask));
            } else {
                LOGGER.warn("Invalid type: '{}' for service task {}", (Object)serviceTask.getType(), (Object)serviceTask.getId());
            }
        } else if ("class".equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createClassDelegateServiceTask((ServiceTask)serviceTask));
        } else if ("delegateExpression".equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskDelegateExpressionActivityBehavior((ServiceTask)serviceTask));
        } else if ("expression".equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskExpressionActivityBehavior((ServiceTask)serviceTask));
        } else if ("##WebService".equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)serviceTask.getOperationRef())) {
            WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior((ServiceTask)serviceTask, bpmnParse.getBpmnModel());
            serviceTask.setBehavior((Object)webServiceActivityBehavior);
        } else {
            LOGGER.warn("One of the attributes 'class', 'delegateExpression', 'type', 'operation', or 'expression' is mandatory on service task {}", (Object)serviceTask.getId());
        }
    }
}

