/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ExternalWorkerServiceTask;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.AbstractExternalWorkerJobCmd;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class ExternalWorkerJobCompleteCmd
extends AbstractExternalWorkerJobCmd
implements Command<Void> {
    protected Map<String, Object> variables;

    public ExternalWorkerJobCompleteCmd(String externalJobId, String workerId, Map<String, Object> variables, JobServiceConfiguration jobServiceConfiguration) {
        super(externalJobId, workerId, jobServiceConfiguration);
        this.variables = variables;
    }

    @Override
    protected void runJobLogic(ExternalWorkerJobEntity externalWorkerJob, CommandContext commandContext) {
        externalWorkerJob.setJobHandlerConfiguration(null);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        VariableServiceConfiguration variableServiceConfiguration = processEngineConfiguration.getVariableServiceConfiguration();
        VariableService variableService = variableServiceConfiguration.getVariableService();
        ExecutionEntity executionEntity = (ExecutionEntity)processEngineConfiguration.getExecutionEntityManager().findById(externalWorkerJob.getExecutionId());
        ExternalWorkerServiceTask externalWorkerServiceTask = (ExternalWorkerServiceTask)executionEntity.getCurrentFlowElement();
        List outParameters = externalWorkerServiceTask.getOutParameters();
        if (outParameters != null && !outParameters.isEmpty()) {
            VariableContainerWrapper temporaryVariableContainer = new VariableContainerWrapper(this.variables);
            for (IOParameter outParameter : outParameters) {
                Object variableValue;
                if (StringUtils.isNotEmpty((CharSequence)outParameter.getSource())) {
                    variableValue = temporaryVariableContainer.getVariable(outParameter.getSource());
                } else {
                    Expression outParameterExpression = processEngineConfiguration.getExpressionManager().createExpression(outParameter.getSourceExpression());
                    variableValue = outParameterExpression.getValue((VariableContainer)temporaryVariableContainer);
                }
                this.addVariable(externalWorkerJob, variableService, outParameter.getTarget(), variableValue);
            }
        } else if (this.variables != null && !this.variables.isEmpty()) {
            for (Map.Entry<String, Object> variableEntry : this.variables.entrySet()) {
                String varName = variableEntry.getKey();
                Object varValue = variableEntry.getValue();
                this.addVariable(externalWorkerJob, variableService, varName, varValue);
            }
        }
        this.moveExternalWorkerJobToExecutableJob(externalWorkerJob, commandContext);
    }

    protected void addVariable(ExternalWorkerJobEntity externalWorkerJob, VariableService variableService, String varName, Object varValue) {
        VariableInstanceEntity variableInstance = variableService.createVariableInstance(varName);
        variableInstance.setScopeId(externalWorkerJob.getProcessInstanceId());
        variableInstance.setSubScopeId(externalWorkerJob.getExecutionId());
        variableInstance.setScopeType("bpmnExternalWorker");
        variableService.insertVariableInstanceWithValue(variableInstance, varValue, externalWorkerJob.getTenantId());
        CountingEntityUtil.handleInsertVariableInstanceEntityCount(variableInstance);
    }
}

