/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.AbstractAggregatingDefaultQueryPersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.authentication.principal.merger.ReplacingAttributeAdder;

public class CascadingPersonAttributeDao
extends AbstractAggregatingDefaultQueryPersonAttributeDao {
    private boolean stopIfFirstDaoReturnsNull;
    private boolean addOriginalAttributesToQuery;

    public CascadingPersonAttributeDao() {
        this.setAttributeMerger((AttributeMerger)new ReplacingAttributeAdder());
    }

    protected Set<PersonAttributes> getAttributesFromDao(Map<String, List<Object>> seed, boolean isFirstQuery, PersonAttributeDao currentlyConsidering, Set<PersonAttributes> resultPeople, PersonAttributeDaoFilter filter) {
        if (isFirstQuery || !this.stopIfFirstDaoReturnsNull && (resultPeople == null || resultPeople.isEmpty())) {
            return currentlyConsidering.getPeopleWithMultivaluedAttributes(seed, filter, resultPeople);
        }
        if (this.stopIfFirstDaoReturnsNull && !isFirstQuery && (resultPeople == null || resultPeople.isEmpty())) {
            return null;
        }
        Set mergedPeopleResults = null;
        for (PersonAttributes person : resultPeople) {
            Set newResults;
            LinkedHashMap<String, List<Object>> queryAttributes = new LinkedHashMap<String, List<Object>>();
            String userName = person.getName();
            if (userName != null) {
                Map userNameMap = this.toSeedMap(userName);
                queryAttributes.putAll(userNameMap);
            }
            Map personAttributes = person.getAttributes();
            queryAttributes.putAll(personAttributes);
            if (this.addOriginalAttributesToQuery) {
                queryAttributes.putAll(seed);
            }
            if ((newResults = currentlyConsidering.getPeopleWithMultivaluedAttributes(queryAttributes, filter, resultPeople)) == null) continue;
            if (mergedPeopleResults == null) {
                mergedPeopleResults = new LinkedHashSet(newResults);
                continue;
            }
            mergedPeopleResults = this.attributeMerger.mergeResults(mergedPeopleResults, newResults);
        }
        return mergedPeopleResults;
    }

    @Generated
    public boolean isStopIfFirstDaoReturnsNull() {
        return this.stopIfFirstDaoReturnsNull;
    }

    @Generated
    public boolean isAddOriginalAttributesToQuery() {
        return this.addOriginalAttributesToQuery;
    }

    @Generated
    public void setStopIfFirstDaoReturnsNull(boolean stopIfFirstDaoReturnsNull) {
        this.stopIfFirstDaoReturnsNull = stopIfFirstDaoReturnsNull;
    }

    @Generated
    public void setAddOriginalAttributesToQuery(boolean addOriginalAttributesToQuery) {
        this.addOriginalAttributesToQuery = addOriginalAttributesToQuery;
    }
}

