/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.token;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import org.apereo.cas.api.PasswordlessAuthenticationRequest;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.impl.token.BasePasswordlessTokenRepository;
import org.apereo.cas.impl.token.PasswordlessAuthenticationToken;
import org.apereo.cas.util.crypto.CipherExecutor;

public class InMemoryPasswordlessTokenRepository
extends BasePasswordlessTokenRepository {
    private static final int INITIAL_CACHE_SIZE = 1000;
    private static final long MAX_CACHE_SIZE = 100000000L;
    private final Cache<String, String> storage;

    public InMemoryPasswordlessTokenRepository(long tokenExpirationInSeconds, CipherExecutor cipherExecutor) {
        super(tokenExpirationInSeconds, (CipherExecutor<Serializable, String>)cipherExecutor);
        this.storage = Caffeine.newBuilder().initialCapacity(1000).maximumSize(100000000L).expireAfterWrite(Duration.ofSeconds(tokenExpirationInSeconds)).build();
    }

    @Override
    public Optional<PasswordlessAuthenticationToken> findToken(String username) {
        return Optional.ofNullable((String)this.storage.getIfPresent((Object)username)).map(this::decodePasswordlessAuthenticationToken);
    }

    @Override
    public void deleteTokens(String username) {
        this.storage.invalidate((Object)username);
    }

    @Override
    public void deleteToken(PasswordlessAuthenticationToken token) {
        this.deleteTokens(token.getUsername());
    }

    @Override
    public PasswordlessAuthenticationToken saveToken(PasswordlessUserAccount passwordlessAccount, PasswordlessAuthenticationRequest passwordlessRequest, PasswordlessAuthenticationToken token) {
        this.storage.put((Object)passwordlessAccount.getUsername(), (Object)this.encodeToken(token));
        return token;
    }

    @Override
    public void clean() {
        this.storage.cleanUp();
    }
}

