/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.monitor.CacheStatistics;
import org.apereo.cas.util.NamedObject;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public abstract class AbstractCacheHealthIndicator
extends AbstractHealthIndicator
implements NamedObject {
    private final long evictionThreshold;
    private final long threshold;

    protected void doHealthCheck(Health.Builder builder) {
        FunctionUtils.doAndHandle(bldr -> {
            CacheStatistics[] statistics = this.getStatistics();
            bldr.withDetail("name", (Object)this.getName());
            if (statistics == null || statistics.length == 0) {
                bldr.outOfService().withDetail("message", (Object)"Cache statistics are not available.");
                return;
            }
            Set statuses = Arrays.stream(statistics).map(this::status).collect(Collectors.toSet());
            if (statuses.contains(Status.OUT_OF_SERVICE)) {
                bldr.outOfService();
            } else if (statuses.contains(Status.DOWN)) {
                bldr.down();
            } else if (statuses.contains(new Status("WARN"))) {
                bldr.status("WARN");
            } else {
                bldr.up();
            }
            Arrays.stream(statistics).forEach(cacheStatistics -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("size", cacheStatistics.getSize());
                map.put("capacity", cacheStatistics.getCapacity());
                map.put("evictions", cacheStatistics.getEvictions());
                map.put("percentFree", cacheStatistics.getPercentFree());
                map.put("state", cacheStatistics.toString(new StringBuilder()));
                bldr.withDetail(cacheStatistics.getName(), map);
            });
        }, throwable -> {
            builder.down(throwable);
            return builder;
        }).accept(builder);
    }

    protected abstract CacheStatistics[] getStatistics();

    protected Status status(CacheStatistics statistics) {
        if (statistics.getEvictions() > 0L && statistics.getEvictions() > this.evictionThreshold) {
            return new Status("WARN");
        }
        if (statistics.getPercentFree() > 0L && statistics.getPercentFree() < this.threshold) {
            return Status.OUT_OF_SERVICE;
        }
        return Status.UP;
    }

    @Generated
    protected AbstractCacheHealthIndicator(long evictionThreshold, long threshold) {
        this.evictionThreshold = evictionThreshold;
        this.threshold = threshold;
    }

    @Generated
    public long getEvictionThreshold() {
        return this.evictionThreshold;
    }

    @Generated
    public long getThreshold() {
        return this.threshold;
    }
}

