/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcCallMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.server.OncRpcServerAuth;
import org.acplt.oncrpc.server.OncRpcServerAuthSchemes;

public class OncRpcServerCallMessage
extends OncRpcCallMessage {
    public OncRpcServerAuth auth = null;
    private OncRpcServerAuthSchemes authenticationSchemes = null;

    public OncRpcServerCallMessage(OncRpcServerAuthSchemes authenticationSchemes) {
        this.authenticationSchemes = authenticationSchemes == null ? OncRpcServerAuthSchemes.getDefaultRepository() : authenticationSchemes;
    }

    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        int authenticationType = -1;
        this.messageId = xdr.xdrDecodeInt();
        this.messageType = xdr.xdrDecodeInt();
        if (this.messageType != 0) {
            throw new OncRpcException(44);
        }
        this.oncRpcVersion = xdr.xdrDecodeInt();
        if (this.oncRpcVersion != 2) {
            throw new OncRpcException(6);
        }
        this.program = xdr.xdrDecodeInt();
        this.version = xdr.xdrDecodeInt();
        this.procedure = xdr.xdrDecodeInt();
        authenticationType = xdr.xdrDecodeInt();
        if (this.auth == null || this.auth.getAuthenticationType() != authenticationType) {
            this.auth = this.authenticationSchemes.getNewHandler(authenticationType);
        }
        if (this.auth == null) {
            throw new OncRpcAuthenticationException(2);
        }
        this.auth.xdrDecodeCredVerf(xdr);
    }
}

