/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="statistics", defaultAccess=Access.NONE)
public class StatisticsEndpoint
extends BaseCasActuatorEndpoint {
    private final ZonedDateTime upTimeStartDate = ZonedDateTime.now(ZoneOffset.UTC);
    private final ObjectProvider<TicketRegistry> ticketRegistry;

    public StatisticsEndpoint(ObjectProvider<TicketRegistry> ticketRegistry, CasConfigurationProperties casProperties) {
        super(casProperties);
        this.ticketRegistry = ticketRegistry;
    }

    @ReadOperation
    @Operation(summary="Get a report of CAS statistics on tickets. Expired tickets will be removed")
    public Map<String, Object> statistics() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Duration diff = Duration.between(this.upTimeStartDate, ZonedDateTime.now(ZoneOffset.UTC));
        model.put("upTime", diff.toSeconds());
        Runtime runtime = Runtime.getRuntime();
        model.put("totalMemory", FileUtils.byteCountToDisplaySize((long)runtime.totalMemory()));
        model.put("maxMemory", FileUtils.byteCountToDisplaySize((long)runtime.maxMemory()));
        model.put("freeMemory", FileUtils.byteCountToDisplaySize((long)runtime.freeMemory()));
        AtomicInteger validTickets = new AtomicInteger();
        AtomicInteger expiredTickets = new AtomicInteger();
        try (Stream stream = ((TicketRegistry)this.ticketRegistry.getObject()).stream();){
            stream.forEach(Unchecked.consumer(ticket -> {
                if (ticket.isExpired()) {
                    ((TicketRegistry)this.ticketRegistry.getObject()).deleteTicket(ticket.getId());
                    expiredTickets.incrementAndGet();
                } else {
                    validTickets.incrementAndGet();
                }
            }));
        }
        model.put("expiredTickets", expiredTickets);
        model.put("validTickets", validTickets);
        return model;
    }
}

