/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.util.CommonHelper;

public class HttpMethodMatcher
implements Matcher {
    private Set<HttpConstants.HTTP_METHOD> methods;

    public HttpMethodMatcher() {
    }

    public HttpMethodMatcher(HttpConstants.HTTP_METHOD ... methods) {
        if (methods != null) {
            this.methods = new HashSet<HttpConstants.HTTP_METHOD>(Arrays.asList(methods));
        }
    }

    @Override
    public boolean matches(CallContext ctx) {
        CommonHelper.assertNotNull("methods", this.methods);
        String requestMethod = ctx.webContext().getRequestMethod();
        for (HttpConstants.HTTP_METHOD method : this.methods) {
            if (!method.name().equalsIgnoreCase(requestMethod)) continue;
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<HttpConstants.HTTP_METHOD> getMethods() {
        return this.methods;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMethods(Set<HttpConstants.HTTP_METHOD> methods) {
        this.methods = methods;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "HttpMethodMatcher(methods=" + this.methods + ")";
    }
}

