/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.CompressionStatistics;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderBin;
import org.apache.sysds.runtime.transform.encode.EncoderFactory;
import org.apache.sysds.runtime.transform.encode.MultiColumnEncoder;

public class CLALibBinCompress {
    public static ColumnEncoderBin.BinMethod binMethod = ColumnEncoderBin.BinMethod.EQUI_WIDTH;

    public static Pair<MatrixBlock, FrameBlock> binCompress(CacheBlock<?> X, MatrixBlock d, int k) {
        String spec = CLALibBinCompress.createSpec(d);
        MultiColumnEncoder encoder = EncoderFactory.createEncoder(spec, null, X.getNumColumns(), null);
        MatrixBlock binned = encoder.encode(X, k, true);
        FrameBlock meta = new FrameBlock(X.getNumColumns(), Types.ValueType.STRING);
        encoder.initMetaData(meta);
        FrameBlock newMeta = encoder.getMetaData(meta, k);
        if (X instanceof MatrixBlock) {
            Pair<MatrixBlock, CompressionStatistics> recompressed = CompressedMatrixBlockFactory.compress(binned, k);
            return new ImmutablePair((Object)((MatrixBlock)recompressed.getKey()), (Object)newMeta);
        }
        return new ImmutablePair((Object)binned, (Object)newMeta);
    }

    private static String createSpec(MatrixBlock d) {
        d.sparseToDense();
        double[] values = d.getDenseBlockValues();
        String binning = binMethod.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"ids\":true,\"bin\":[");
        for (int i = 0; i < values.length; ++i) {
            stringBuilder.append(String.format("{\"id\":%d,\"method\":\"%s\",\"numbins\":%d}", i + 1, binning, (int)values[i]));
            if (i + 1 >= values.length) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }
}

